/*
 * Decompiled with CFR 0.152.
 */
package anon.forward;

import anon.client.TrustModel;
import anon.forward.LocalAddress;
import anon.forward.LocalForwarder;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.shared.ProxyConnection;
import anon.transport.address.IAddress;
import anon.transport.address.SkypeAddress;
import anon.transport.address.TcpIpAddress;
import anon.transport.connection.ConnectionException;
import anon.transport.connection.IStreamConnection;
import anon.transport.connector.SkypeConnector;
import java.net.Socket;
import logging.LogHolder;
import logging.LogType;

public class ForwardUtils {
    private static ForwardUtils ms_fuInstance = null;
    ImmutableProxyInterface m_proxyInterface;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;

    public static ForwardUtils getInstance() {
        if (ms_fuInstance == null) {
            ms_fuInstance = new ForwardUtils();
        }
        return ms_fuInstance;
    }

    private ForwardUtils() {
    }

    public synchronized void setProxySettings(ImmutableProxyInterface a_proxyInterface) {
        this.m_proxyInterface = a_proxyInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyConnection createProxyConnection(String a_host, int a_port) {
        ProxyConnection proxyConnection = null;
        try {
            ForwardUtils forwardUtils = this;
            synchronized (forwardUtils) {
                proxyConnection = new ProxyConnection(HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(a_host, a_port), this.m_proxyInterface).Connect());
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
        }
        return proxyConnection;
    }

    public IStreamConnection createForwardingConnection(IAddress a_address) {
        TrustModel.getCurrentTrustModel().unblockInterfacesFromDatabase();
        ListenerInterface.unblockInterfacesFromDatabase(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = ForwardUtils.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry);
        if (a_address instanceof TcpIpAddress) {
            TcpIpAddress spezialisedAddress = (TcpIpAddress)a_address;
            return this.createProxyConnection(spezialisedAddress.getHostname(), spezialisedAddress.getPort());
        }
        if (a_address instanceof SkypeAddress) {
            LogHolder.log(7, LogType.NET, "forwardUtils:createconnection() start connection to skype forwarder");
            SkypeConnector connector = new SkypeConnector();
            LogHolder.log(7, LogType.NET, "forwardUtils:createconnection() skype conector object created");
            try {
                return connector.connect((SkypeAddress)a_address);
            }
            catch (ConnectionException e) {
                LogHolder.log(3, LogType.TRANSPORT, "Unable to create Skype Forwarding Connection. Cause: " + e.getMessage());
            }
        } else if (a_address instanceof LocalAddress) {
            try {
                return (IStreamConnection)LocalForwarder.getConnector().connect(a_address);
            }
            catch (ConnectionException e) {
                LogHolder.log(3, LogType.TRANSPORT, "unable to contact local forwarder. " + e.getMessage());
            }
        }
        return null;
    }

    public Socket createConnection(String a_host, int a_port) {
        ProxyConnection proxyConnection = this.createProxyConnection(a_host, a_port);
        Socket newSocket = null;
        if (proxyConnection != null) {
            newSocket = proxyConnection.getSocket();
        }
        return newSocket;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

