/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.XMLSignature;
import anon.pay.xml.XMLPriceCertificate;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLPriceCertificateList
implements IXMLEncodable {
    private Vector m_thePriceCerts;
    private Document m_docThePriceCerts;
    private static final String ms_strElemName = "PriceCertificateList";

    public XMLPriceCertificateList(Vector a_priceCerts) {
        this.m_thePriceCerts = a_priceCerts;
        this.m_docThePriceCerts = XMLUtil.createDocument();
        this.m_docThePriceCerts = this.internal_toXmlElement(this.m_docThePriceCerts);
    }

    private Document internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(ms_strElemName);
        elemRoot.setAttribute("version", "1.0");
        a_doc.appendChild(elemRoot);
        Enumeration allCerts = this.m_thePriceCerts.elements();
        while (allCerts.hasMoreElements()) {
            XMLPriceCertificate curCert = (XMLPriceCertificate)allCerts.nextElement();
            try {
                Element certElem = curCert.toXmlElement(a_doc);
                elemRoot.appendChild(certElem);
            }
            catch (DOMException de) {
                LogHolder.log(7, LogType.PAY, de.getMessage());
            }
        }
        return a_doc;
    }

    public XMLPriceCertificateList(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.m_thePriceCerts = new Vector();
        this.setValues(doc.getDocumentElement());
        this.m_docThePriceCerts = doc;
    }

    public XMLPriceCertificateList(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.m_thePriceCerts = new Vector();
        this.setValues(doc.getDocumentElement());
        this.m_docThePriceCerts = doc;
    }

    public XMLPriceCertificateList(Element xml) throws Exception {
        this.m_thePriceCerts = new Vector();
        this.setValues(xml);
        this.m_docThePriceCerts = XMLUtil.createDocument();
        this.m_docThePriceCerts.appendChild(XMLUtil.importNode(this.m_docThePriceCerts, xml, true));
    }

    public XMLPriceCertificateList(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.m_thePriceCerts = new Vector();
        this.setValues(elemRoot);
        this.m_docThePriceCerts = xml;
    }

    public Vector getPriceCerts() {
        return this.m_thePriceCerts;
    }

    public static String getXMLElementName() {
        return ms_strElemName;
    }

    public Vector getPriceCertHashes() {
        Vector<String> allHashes = new Vector<String>();
        Enumeration e = this.m_thePriceCerts.elements();
        while (e.hasMoreElements()) {
            XMLPriceCertificate curCert = (XMLPriceCertificate)e.nextElement();
            String curHash = XMLSignature.getHashValueOfElement(curCert.getDocument());
            allHashes.addElement(curHash);
        }
        return allHashes;
    }

    private void setValues(Element root) throws Exception {
        if (!root.getTagName().equals(ms_strElemName)) {
            throw new Exception("XMLPriceCertificateList: cannot parse, wrong xml format!");
        }
        if (!root.getAttribute("version").equals("1.0")) {
            throw new Exception("XMLPriceCertificate: cannot parse, cert version is " + root.getAttribute("version") + " but 1.0 was expected.");
        }
        NodeList allCerts = root.getElementsByTagName("PriceCertificate");
        if (allCerts == null) {
            throw new Exception("XMLPriceCertificate: cannot parse price certificates");
        }
        int i = 0;
        while (allCerts.item(i) != null) {
            Element curCertElem = (Element)allCerts.item(i);
            XMLPriceCertificate curCert = new XMLPriceCertificate(curCertElem);
            this.m_thePriceCerts.addElement(curCert);
            ++i;
        }
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docThePriceCerts.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

