/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.AnonChannel;
import anon.NotConnectedToMixException;
import anon.TooMuchDataForPacketException;
import anon.proxy.AnonProxy;
import anon.proxy.ProxyCallbackBuffer;
import anon.proxy.ProxyCallbackDelayException;
import anon.proxy.ProxyCallbackHandler;
import anon.proxy.ProxyCallbackNotProcessableException;
import anon.util.SocketGuard;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public final class AnonProxyRequest
implements Runnable {
    private static int ms_nrOfRequests = 0;
    private static final long TIMEOUT_RECONNECT = 60000L;
    private static final int CHUNK_SIZE = 1000;
    private static int ms_currentRequest;
    private AnonChannel m_Channel;
    private InputStream m_InChannel;
    private OutputStream m_OutChannel;
    private SocketGuard m_clientSocket;
    private InputStream m_InSocket;
    private OutputStream m_OutSocket;
    private Thread m_threadResponse;
    private Thread m_threadRequest;
    private Hashtable m_hashParsedDomains = new Hashtable();
    private boolean m_bShowBrowserWarning = false;
    private AnonProxy m_Proxy;
    private volatile boolean m_bRequestIsAlive;
    private int m_iProtocol;
    private final Object m_syncObject;
    private ProxyCallbackHandler m_callbackHandler = null;
    private String[] contentEncodings;
    private boolean internalEncodingRequired = false;

    AnonProxyRequest(AnonProxy proxy, SocketGuard clientSocket, Object a_syncObject, ProxyCallbackHandler callbackHandler) throws IOException {
        this.m_Proxy = proxy;
        this.m_clientSocket = clientSocket;
        this.m_syncObject = a_syncObject;
        this.m_clientSocket.setSoTimeout(0);
        this.m_InSocket = clientSocket.getInputStream();
        this.m_OutSocket = clientSocket.getOutputStream();
        this.m_threadRequest = new Thread((Runnable)this, "JAP - AnonProxy Request " + Integer.toString(ms_currentRequest));
        ++ms_currentRequest;
        this.m_callbackHandler = callbackHandler;
        this.m_threadRequest.setDaemon(true);
        this.m_threadRequest.start();
    }

    public int getAnonymityDistribution() {
        return this.m_Proxy.getMixCascade().getDistribution();
    }

    public static int getNrOfRequests() {
        return ms_nrOfRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ++ms_nrOfRequests;
        this.m_bRequestIsAlive = true;
        AnonChannel newChannel = null;
        boolean bIsSMTP = false;
        int firstByte = 0;
        try {
            firstByte = this.m_InSocket.read();
        }
        catch (InterruptedIOException ex) {
            try {
                bIsSMTP = true;
                newChannel = this.m_Proxy.createChannel(3);
                this.m_iProtocol = 0;
                if (newChannel == null) {
                    this.closeRequest();
                    return;
                }
            }
            catch (Throwable to) {
                LogHolder.log(3, LogType.NET, "AnonProxyRequest - something was wrong with setting up a new SMTP channel -- Exception: " + to);
                this.closeRequest();
                return;
            }
        }
        catch (Throwable t) {
            this.closeRequest();
            return;
        }
        if (newChannel == null) {
            firstByte &= 0xFF;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    newChannel = null;
                    if (firstByte == 4 || firstByte == 5) {
                        newChannel = this.m_Proxy.createChannel(1);
                        this.m_iProtocol = 0;
                        break;
                    }
                    newChannel = this.m_Proxy.createChannel(0);
                    this.m_iProtocol = 1;
                    break;
                }
                catch (NotConnectedToMixException ec) {
                    LogHolder.log(3, LogType.NET, "AnonProxyRequest - Connection to Mix lost");
                    Thread timeoutThread = new Thread(new Runnable(){

                        public void run() {
                            AnonProxyRequest.this.m_Proxy.reconnect();
                        }
                    }, "Request reconnect thread");
                    timeoutThread.start();
                    long currentTime = System.currentTimeMillis();
                    try {
                        timeoutThread.join(60000L);
                    }
                    catch (InterruptedException ex1) {
                        Thread.currentThread().interrupt();
                    }
                    boolean success = true;
                    Object object = this.m_syncObject;
                    synchronized (object) {
                        long remainder;
                        if (!this.m_Proxy.isConnected() && !Thread.currentThread().isInterrupted() && (remainder = currentTime + 60000L - System.currentTimeMillis()) > 0L) {
                            try {
                                this.m_syncObject.wait(remainder);
                            }
                            catch (InterruptedException ex2) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                        }
                        if (!this.m_Proxy.isConnected()) {
                            success = false;
                        }
                    }
                    if (success) continue;
                    LogHolder.log(3, LogType.NET, "Requests terminated due to loss of connection to service!");
                    this.closeRequest();
                    return;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.NET, "AnonProxyRequest - something was wrong with seting up a new channel. Exception: " + e);
                    this.closeRequest();
                    return;
                }
            }
            if (newChannel == null) {
                this.closeRequest();
                return;
            }
        }
        int len = 0;
        int aktPos = 0;
        if (!bIsSMTP) {
            aktPos = 1;
        }
        byte[] buff = null;
        ProxyCallbackBuffer pcBuffer = null;
        try {
            this.m_Channel = newChannel;
            this.m_InChannel = newChannel.getInputStream();
            this.m_OutChannel = newChannel.getOutputStream();
            this.m_threadResponse = new Thread((Runnable)new Response(), "JAP - AnonProxy Response for " + Thread.currentThread().getName());
            this.m_threadResponse.start();
            buff = new byte[1900];
            buff[0] = (byte)firstByte;
        }
        catch (Throwable t) {
            this.closeRequest();
            return;
        }
        this.m_Proxy.incNumChannels();
        try {
            while (true) {
                try {
                    len = Math.min(this.m_Channel.getOutputBlockSize(), 1900);
                    len -= aktPos;
                    len = this.m_InSocket.read(buff, aktPos, len);
                }
                catch (InterruptedIOException ioe) {
                    aktPos += ioe.bytesTransferred;
                    continue;
                }
                if ((len += aktPos) < 0) break;
                try {
                    if (this.m_callbackHandler != null && len > 0) {
                        pcBuffer = new ProxyCallbackBuffer(buff, 0, len);
                        try {
                            this.m_callbackHandler.deliverUpstream(this, pcBuffer);
                        }
                        catch (ProxyCallbackDelayException e) {
                            aktPos = 0;
                            continue;
                        }
                        this.m_OutChannel.write(pcBuffer.getChunk(), 0, pcBuffer.getPayloadLength());
                    } else {
                        this.m_OutChannel.write(buff, 0, len);
                    }
                    aktPos = 0;
                }
                catch (TooMuchDataForPacketException e) {
                    if (this.m_callbackHandler != null) {
                        AnonProxyRequest.sendRemainingBytesRecursion(pcBuffer, e.getBytesSent(), this.m_OutChannel);
                        aktPos = 0;
                    }
                    byte[] tempBuff = new byte[buff.length - e.getBytesSent()];
                    System.arraycopy(buff, e.getBytesSent(), tempBuff, 0, tempBuff.length);
                    System.arraycopy(tempBuff, 0, buff, 0, tempBuff.length);
                    aktPos = tempBuff.length;
                }
                this.m_Proxy.transferredBytes(len - aktPos, this.m_iProtocol);
                Thread.yield();
            }
        }
        catch (IOException e) {
            LogHolder.log(7, LogType.NET, "Exception in AnonProxyRequest - upstream loop.", e);
        }
        catch (ProxyCallbackNotProcessableException cnpe) {
            try {
                this.m_OutSocket.write(cnpe.getErrorResponse());
            }
            catch (IOException e) {
                // empty catch block
            }
            LogHolder.log(3, LogType.NET, "chunk could not be processed. Terminating", cnpe);
        }
        this.closeRequest();
        this.m_Proxy.decNumChannels();
    }

    private static void sendRemainingBytesRecursion(ProxyCallbackBuffer pcBuffer, int sentBytes, OutputStream outputStream) throws IOException {
        byte[] tempBuff = new byte[pcBuffer.getPayloadLength() - sentBytes];
        System.arraycopy(pcBuffer.getChunk(), sentBytes, tempBuff, 0, tempBuff.length);
        System.arraycopy(tempBuff, 0, pcBuffer.getChunk(), 0, tempBuff.length);
        try {
            outputStream.write(tempBuff);
        }
        catch (TooMuchDataForPacketException e) {
            pcBuffer.setChunk(tempBuff);
            AnonProxyRequest.sendRemainingBytesRecursion(pcBuffer, e.getBytesSent(), outputStream);
        }
    }

    private synchronized void closeRequest() {
        if (this.m_bRequestIsAlive) {
            --ms_nrOfRequests;
            this.m_bRequestIsAlive = false;
        }
        try {
            if (this.m_Channel != null) {
                this.m_Channel.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.m_InSocket.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.m_OutSocket.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            this.m_clientSocket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.m_callbackHandler != null) {
            this.m_callbackHandler.closeRequest(this);
        }
    }

    protected void setHttpParsed(String a_strDomain) {
        if (a_strDomain != null && !this.isProxyKeepAliveEnabled()) {
            this.m_hashParsedDomains.put(a_strDomain, a_strDomain);
        }
    }

    protected boolean isProxyKeepAliveEnabled() {
        return this.m_hashParsedDomains.size() > 0;
    }

    public boolean isInternalEncodingRequired() {
        return this.internalEncodingRequired;
    }

    public void showBrowserWarning(boolean a_bShow) {
        this.m_bShowBrowserWarning = a_bShow;
    }

    public boolean isBrowserWarningShown() {
        return this.m_bShowBrowserWarning;
    }

    protected void setInternalEncodingRequired(boolean internalEncodingRequired) {
        this.internalEncodingRequired = internalEncodingRequired;
    }

    protected String[] getContentEncodings() {
        return this.contentEncodings;
    }

    protected void setContentEncodings(String[] contentEncodings) {
        this.contentEncodings = contentEncodings;
    }

    final class Response
    implements Runnable {
        Response() {
        }

        public void run() {
            byte[] buff;
            block22: {
                int len = 0;
                buff = new byte[2900];
                try {
                    ProxyCallbackBuffer pcBuffer = null;
                    while ((len = AnonProxyRequest.this.m_InChannel.read(buff, 0, 1000)) >= 0) {
                        block21: {
                            int count = 0;
                            while (true) {
                                try {
                                    if (AnonProxyRequest.this.m_callbackHandler != null && len > 0) {
                                        pcBuffer = new ProxyCallbackBuffer(buff, 0, len);
                                        try {
                                            AnonProxyRequest.this.m_callbackHandler.deliverDownstream(AnonProxyRequest.this, pcBuffer);
                                        }
                                        catch (ProxyCallbackDelayException e) {
                                            break block21;
                                        }
                                        AnonProxyRequest.this.m_OutSocket.write(pcBuffer.getChunk(), 0, pcBuffer.getPayloadLength());
                                        if (pcBuffer.getStatus() == 0) {
                                            break block22;
                                        }
                                    } else {
                                        AnonProxyRequest.this.m_OutSocket.write(buff, 0, len);
                                    }
                                    AnonProxyRequest.this.m_OutSocket.flush();
                                }
                                catch (InterruptedIOException ioe) {
                                    LogHolder.log(0, LogType.NET, "Should never be here: Timeout in sending to Browser!");
                                    if (++count <= 3) continue;
                                    throw new IOException("Could not send to Browser...");
                                }
                                break;
                            }
                            AnonProxyRequest.this.m_Proxy.transferredBytes(len, AnonProxyRequest.this.m_iProtocol);
                            Thread.yield();
                        }
                        if (len >= 0 && !AnonProxyRequest.this.m_Channel.isClosed()) continue;
                        break;
                    }
                }
                catch (IOException e) {
                    if (!AnonProxyRequest.this.m_Proxy.isConnected() && !AnonProxyRequest.this.m_Proxy.isConnecting()) {
                        LogHolder.log(3, LogType.NET, e);
                    } else {
                        LogHolder.log(6, LogType.NET, e);
                    }
                }
                catch (ProxyCallbackNotProcessableException cnpe) {
                    LogHolder.log(3, LogType.NET, cnpe);
                    try {
                        AnonProxyRequest.this.m_OutSocket.write(cnpe.getErrorResponse());
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            try {
                AnonProxyRequest.this.m_clientSocket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (AnonProxyRequest.this.m_bRequestIsAlive) {
                AnonProxyRequest.this.m_threadRequest.interrupt();
            }
            buff = null;
        }
    }
}

