/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos;

import infoservice.agreement.paxos.PaxosAcceptor;
import infoservice.agreement.paxos.PaxosExecution;
import infoservice.agreement.paxos.PaxosObject;
import infoservice.agreement.paxos.messages.PaxosMessage;
import java.util.Hashtable;

public class PaxosInstance
extends PaxosObject {
    private Hashtable m_decissions = new Hashtable();
    protected Hashtable m_executions = new Hashtable();
    private String m_instanceNumber;
    private PaxosAcceptor m_acceptor;
    private boolean m_notified = false;

    public PaxosInstance(PaxosAcceptor a_acceptor, String a_instanceNumber) {
        this.m_instanceNumber = a_instanceNumber;
        this.m_acceptor = a_acceptor;
    }

    public PaxosAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    public PaxosExecution getExecution(PaxosMessage a_msg) {
        PaxosExecution result = (PaxosExecution)this.m_executions.get(a_msg.getInitiator());
        if (result == null) {
            this.error("Unknown PaxosExecution requested! (" + a_msg.getInitiator() + "), problably inconsistent InfoService");
        }
        return result;
    }

    public Hashtable getDecissions() {
        return this.m_decissions;
    }

    public Hashtable getExecutions() {
        return this.m_executions;
    }

    public String getInstanceNumber() {
        return this.m_instanceNumber;
    }

    public void addDecision(String a_initiator, String a_value) {
        this.m_decissions.put(a_initiator, a_value);
        if (this.m_decissions.size() >= this.m_acceptor.getN() && !this.m_notified) {
            this.m_notified = true;
            this.m_acceptor.notifyAgreement(this.m_decissions);
        }
    }
}

