/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientUtil;
import HTTPClient.HttpOutputStream;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class AuthorizationModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private static Hashtable deferred_auth_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private Request saved_req = null;
    private Response saved_resp = null;

    AuthorizationModule() {
    }

    public int requestHandler(Request req, Response[] resp) throws IOException, AuthSchemeNotImplException {
        block12: {
            AuthorizationInfo guess;
            block14: {
                AuthorizationHandler auth_handler;
                block11: {
                    block13: {
                        Hashtable proxy_auth_list;
                        HTTPConnection con = req.getConnection();
                        auth_handler = AuthorizationInfo.getAuthHandler();
                        HttpOutputStream out = req.getStream();
                        if (out != null && deferred_auth_list.get(out) != null) {
                            this.copyFrom((AuthorizationModule)deferred_auth_list.get(out));
                            req.copyFrom(this.saved_req);
                            deferred_auth_list.remove(out);
                            this.handle_auth_challenge(req, this.saved_resp);
                            return 1;
                        }
                        if (con.getProxyHost() == null || this.prxy_from_4xx || (guess = (AuthorizationInfo)(proxy_auth_list = HttpClientUtil.getList(proxy_cntxt_list, req.getConnection().getContext())).get(con.getProxyHost() + ":" + con.getProxyPort())) == null) break block11;
                        if (auth_handler == null) break block13;
                        try {
                            guess = auth_handler.fixupAuthInfo(guess, req, null, null, true);
                        }
                        catch (AuthSchemeNotImplException atnie) {
                            break block11;
                        }
                        if (guess == null) break block11;
                    }
                    req.setHeaders(HttpClientUtil.setValue(req.getHeaders(), "Proxy-Authorization", guess.toString()));
                    this.prxy_sent = guess;
                    this.prxy_from_4xx = false;
                }
                if (this.auth_from_4xx || (guess = AuthorizationInfo.findBest(req)) == null) break block12;
                if (auth_handler == null) break block14;
                try {
                    guess = auth_handler.fixupAuthInfo(guess, req, null, null, false);
                }
                catch (AuthSchemeNotImplException atnie) {
                    break block12;
                }
                if (guess == null) break block12;
            }
            req.setHeaders(HttpClientUtil.setValue(req.getHeaders(), "Authorization", guess.toString()));
            this.auth_sent = guess;
            this.auth_from_4xx = false;
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        if (resp.getStatusCode() != 401 && resp.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, req, resp, false, false).addPath(req.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthHeaders(resp, req, this.auth_sent, this.prxy_sent);
        }
        int sts = resp.getStatusCode();
        switch (sts) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (req.getStream() != null) {
                    this.saved_req = (Request)req.clone();
                    this.saved_resp = (Response)resp.clone();
                    deferred_auth_list.put(req.getStream(), this);
                    req.getStream().reset();
                    resp.setRetryRequest(true);
                    return 10;
                }
                this.handle_auth_challenge(req, resp);
                if (this.auth_sent == null && this.prxy_sent == null) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthTrailers(resp, req, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request req, Response resp) throws AuthSchemeNotImplException, IOException {
        int[] idx_arr = new int[]{this.auth_lst_idx, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(resp.getHeader("WWW-Authenticate"), req, resp, "Authorization", false, idx_arr, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
        }
        this.auth_lst_idx = idx_arr[0];
        this.auth_scm_idx = idx_arr[1];
        idx_arr[0] = this.prxy_lst_idx;
        idx_arr[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(resp.getHeader("Proxy-Authenticate"), req, resp, "Proxy-Authorization", true, idx_arr, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
        }
        this.prxy_lst_idx = idx_arr[0];
        this.prxy_scm_idx = idx_arr[1];
        if (this.prxy_sent != null) {
            HTTPConnection con = req.getConnection();
            HttpClientUtil.getList(proxy_cntxt_list, con.getContext()).put(con.getProxyHost() + ":" + con.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && resp.getHeader("WWW-Authenticate") == null && resp.getHeader("Proxy-Authenticate") == null) {
            if (resp.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
            throw new ProtocolException("Missing Proxy-Authenticate header");
        }
    }

    private AuthorizationInfo setAuthHeaders(String auth_str, Request req, RoResponse resp, String header, boolean proxy_auth, int[] idx_arr, AuthorizationInfo prev) throws ProtocolException, AuthSchemeNotImplException {
        if (auth_str == null) {
            return null;
        }
        HTTPConnection con = req.getConnection();
        AuthorizationInfo[] challenge = proxy_auth && con.getProxyHost() != null ? AuthorizationInfo.parseAuthString(auth_str, con.getProxyHost(), con.getProxyPort()) : AuthorizationInfo.parseAuthString(auth_str, con.getHost(), con.getPort());
        if (prev != null && prev.getScheme().equalsIgnoreCase("Basic")) {
            for (int idx = 0; idx < challenge.length; ++idx) {
                if (!prev.getRealm().equals(challenge[idx].getRealm()) || !prev.getScheme().equalsIgnoreCase(challenge[idx].getScheme())) continue;
                AuthorizationInfo.removeAuthorization(prev, con.getContext());
            }
        }
        AuthorizationInfo credentials = null;
        AuthorizationHandler auth_handler = AuthorizationInfo.getAuthHandler();
        if (auth_handler != null && (challenge = auth_handler.orderChallenges(challenge, req, resp, proxy_auth)) == null) {
            return null;
        }
        while (credentials == null && idx_arr[0] != -1) {
            credentials = AuthorizationInfo.getAuthorization(challenge[idx_arr[0]], req, resp, proxy_auth, false);
            if (auth_handler != null && credentials != null) {
                credentials = auth_handler.fixupAuthInfo(credentials, req, challenge[idx_arr[0]], resp, proxy_auth);
            }
            if ((idx_arr[0] = idx_arr[0] + 1) != challenge.length) continue;
            idx_arr[0] = -1;
        }
        if (credentials == null) {
            for (int idx = 0; idx < challenge.length; ++idx) {
                try {
                    credentials = AuthorizationInfo.queryAuthHandler(challenge[idx_arr[1]], req, resp, proxy_auth);
                    break;
                }
                catch (AuthSchemeNotImplException atnie) {
                    if (idx != challenge.length - 1) continue;
                    throw atnie;
                }
            }
            if ((idx_arr[1] = idx_arr[1] + 1) == challenge.length) {
                idx_arr[1] = 0;
            }
        }
        if (credentials == null) {
            return null;
        }
        req.setHeaders(HttpClientUtil.setValue(req.getHeaders(), header, credentials.toString()));
        return credentials;
    }

    private void copyFrom(AuthorizationModule other) {
        this.auth_lst_idx = other.auth_lst_idx;
        this.prxy_lst_idx = other.prxy_lst_idx;
        this.auth_scm_idx = other.auth_scm_idx;
        this.prxy_scm_idx = other.prxy_scm_idx;
        this.auth_sent = other.auth_sent;
        this.prxy_sent = other.prxy_sent;
        this.auth_from_4xx = other.auth_from_4xx;
        this.prxy_from_4xx = other.prxy_from_4xx;
        this.num_tries = other.num_tries;
        this.saved_req = other.saved_req;
        this.saved_resp = other.saved_resp;
    }
}

