/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

import anon.anonudp.exception.SymmetricKeyCreationFailed;
import anon.anonudp.mixmessage.Util;
import anon.anonudp.mixmessage.crypto.BlindingFactor;
import anon.anonudp.mixmessage.crypto.Counter;
import anon.anonudp.mixmessage.crypto.EccGroup713;
import anon.anonudp.mixmessage.crypto.PrivateKey;
import anon.crypto.ByteSignature;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;
import org.bouncycastle.math.ec.ECPoint;

public class PublicKey {
    public static final int SIZE = 29;
    private final ECPoint underlyingValue;

    public PublicKey(PrivateKey privateKey) {
        this.underlyingValue = EccGroup713.powInGroup(EccGroup713.getGenerator(), privateKey.getUnderlyingValue());
    }

    private PublicKey(ECPoint point) {
        this.underlyingValue = point;
    }

    public byte[] toSymmetricKey() throws SymmetricKeyCreationFailed {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = "aes_key:".getBytes();
            bos.write(buff);
            buff = this.underlyingValue.getEncoded(false);
            System.out.println("Point: " + ByteSignature.toHexString(buff));
            bos.write(buff);
            bos.close();
            byte[] hash2 = digest.digest(bos.toByteArray());
            System.out.println("Hash: " + ByteSignature.toHexString(hash2));
            return Util.copyOf(hash2, 16);
        }
        catch (Exception e) {
            throw new SymmetricKeyCreationFailed("Turning public key into symmetric key failed.", e);
        }
    }

    public PublicKey blind(PrivateKey privateKey) {
        BlindingFactor blindingFactor = new BlindingFactor(privateKey);
        return this.blind(blindingFactor);
    }

    public PublicKey blind(PublicKey publicKey) throws SymmetricKeyCreationFailed {
        BlindingFactor blindingFactor = new BlindingFactor(publicKey);
        return this.blind(blindingFactor);
    }

    public PublicKey blind(byte[] messageCounterPrefix) throws SymmetricKeyCreationFailed {
        byte[] iv = new Counter(messageCounterPrefix).asIV();
        BlindingFactor blindingFactor = new BlindingFactor(iv);
        return this.blind(blindingFactor);
    }

    private PublicKey blind(BlindingFactor blindingFactor) {
        return new PublicKey(EccGroup713.powInGroup(this.underlyingValue, blindingFactor.getUnderlyingValue()));
    }

    private ECPoint getUnderlyingValue() {
        return this.underlyingValue;
    }

    public static PublicKey fromBytes(byte[] binaryKey) {
        return new PublicKey(EccGroup713.loadPoint(binaryKey));
    }

    public byte[] toBytes() {
        return this.underlyingValue.getEncoded(true);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PublicKey) {
            return this.underlyingValue.equals(((PublicKey)obj).getUnderlyingValue());
        }
        return super.equals(obj);
    }
}

