/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.MixParameters;
import anon.client.crypto.DataChannelCipher;
import anon.client.crypto.IDataChannelChipher;
import anon.client.crypto.IMixCipher;
import anon.util.Base64;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class LastMixCipher
implements IMixCipher {
    private boolean m_firstEncryptionPacket = true;
    private MixParameters m_mixParameters;
    private IDataChannelChipher m_dataChannelCipher;
    private boolean m_bDebug = false;

    public LastMixCipher(MixParameters a_mixParameters, IDataChannelChipher a_dataChannelCipher, boolean bDebug) {
        this.m_mixParameters = a_mixParameters;
        this.m_dataChannelCipher = a_dataChannelCipher;
        this.m_bDebug = bDebug;
    }

    public byte[] encrypt(byte[] a_packet, int a_virtualPacketLength, Vector a_sendCallbackHandlers) {
        int payloadLen = a_packet[0] << 8 & 0x3F00 | a_packet[1] & 0xFF;
        byte[] symEncryptedPacket = new byte[payloadLen + 3 + DataChannelCipher.getMACSize()];
        byte[] symmetricKey = null;
        if (this.m_firstEncryptionPacket) {
            symmetricKey = this.m_dataChannelCipher.getKeys();
            symmetricKey[0] = (byte)(symmetricKey[0] & 0x7F);
            this.m_dataChannelCipher.setEncryptionKeysAES(symmetricKey);
        }
        try {
            this.m_dataChannelCipher.encryptGCM1(a_packet, 0, symEncryptedPacket, 0, payloadLen + 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.m_firstEncryptionPacket) {
            return symEncryptedPacket;
        }
        int asymInBlockSize = this.m_mixParameters.getMixCipher().getInputBlockSize();
        int asymOutBlockSize = this.m_mixParameters.getMixCipher().getOutputBlockSize();
        int asymPaddingSize = this.m_mixParameters.getMixCipher().getPaddingSize();
        byte[] asymOutBlock = new byte[Math.max(symmetricKey.length + symEncryptedPacket.length + asymPaddingSize, asymOutBlockSize)];
        byte[] asymInBlock = new byte[asymInBlockSize];
        int asymPayloadSize = asymInBlock.length - symmetricKey.length;
        System.arraycopy(symmetricKey, 0, asymInBlock, 0, symmetricKey.length);
        System.arraycopy(symEncryptedPacket, 0, asymInBlock, symmetricKey.length, Math.min(asymPayloadSize, symEncryptedPacket.length));
        this.m_mixParameters.getMixCipher().encrypt(asymInBlock, 0, asymOutBlock, 0);
        if (symEncryptedPacket.length > asymPayloadSize) {
            System.arraycopy(symEncryptedPacket, asymPayloadSize, asymOutBlock, asymOutBlockSize, symEncryptedPacket.length - asymPayloadSize);
        }
        this.m_firstEncryptionPacket = false;
        return asymOutBlock;
    }

    public boolean decrypt(byte[] a_packet) {
        try {
            if (this.m_bDebug) {
                LogHolder.log(7, LogType.CRYPTO, "LastMixDecryption - AN.ON Debug Mode Received Packet data: " + Base64.encode(a_packet, false));
            }
            this.m_dataChannelCipher.decryptGCM2(a_packet, 0, a_packet, 0, a_packet.length);
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.CRYPTO, "Decryption of MixPacket with integrity check failed: " + e.getMessage());
            return false;
        }
        return true;
    }

    public int getNextPacketEncryptionOverhead() {
        int overhead = DataChannelCipher.getMACSize();
        if (this.m_firstEncryptionPacket) {
            overhead += this.m_dataChannelCipher.getKeys().length + this.m_mixParameters.getMixCipher().getPaddingSize();
        }
        return overhead;
    }
}

