/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import java.security.SecureRandom;
import java.util.Random;

public final class MyRandom {
    Random m_TheRandom;

    public MyRandom(Random rand) {
        this.m_TheRandom = rand;
    }

    public MyRandom() {
        this(new SecureRandom());
    }

    public int nextInt(int max) {
        int v;
        int randMax = Integer.MAX_VALUE;
        randMax -= randMax % max;
        do {
            v = this.m_TheRandom.nextInt();
        } while ((v &= Integer.MAX_VALUE) >= randMax);
        return v % max;
    }

    public Random getRandSource() {
        return this.m_TheRandom;
    }

    public void setSeed(long randomSeed) {
        this.m_TheRandom.setSeed(randomSeed);
    }

    public void setSeed(long randomSeed, boolean bReplaceSeed) {
        if (bReplaceSeed) {
            if (this.m_TheRandom instanceof SecureRandom) {
                this.m_TheRandom = new Random(randomSeed);
            } else {
                this.m_TheRandom.setSeed(randomSeed);
            }
        } else if (this.m_TheRandom instanceof SecureRandom) {
            this.m_TheRandom.setSeed(randomSeed);
        } else {
            this.m_TheRandom = new SecureRandom();
            this.m_TheRandom.setSeed(randomSeed);
        }
    }

    public long nextLong() {
        return this.m_TheRandom.nextLong();
    }
}

