/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.ByteSignature;
import anon.crypto.CertPath;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.JAPCertificate;
import anon.crypto.XMLSignature;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLSignatureElement
implements IXMLEncodable {
    private static final String XML_ELEMENT_NAME = "Signature";
    private static final String ELEM_CANONICALIZATION_METHOD = "CanonicalizationMethod";
    private static final String ELEM_SIGNATURE_METHOD = "SignatureMethod";
    private static final String ELEM_SIGNATURE_VALUE = "SignatureValue";
    private static final String ELEM_KEY_INFO = "KeyInfo";
    private static final String ELEM_SIGNED_INFO = "SignedInfo";
    private static final String ELEM_REFERENCE = "Reference";
    private static final String ELEM_DIGEST_VALUE = "DigestValue";
    private static final String ELEM_DIGEST_METHOD = "DigestMethod";
    private static final String ATTR_URI = "URI";
    private static final String ATTR_ALGORITHM = "Algorithm";
    private static final String DIGEST_METHOD_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    private XMLSignature m_parent;
    private Element m_elemSignature;
    private String m_signatureMethod;
    private String m_signatureValue;
    private String m_referenceURI;
    private String m_digestMethod;
    private String m_digestValue;
    private byte[] m_signedInfoCanonical;
    private Vector m_appendedCerts;
    private Vector m_appendedCertXMLElements;
    private CertPath m_certPath;

    protected XMLSignatureElement(XMLSignature a_parent) {
        this.m_parent = a_parent;
        this.m_appendedCerts = new Vector();
        this.m_appendedCertXMLElements = new Vector();
    }

    protected XMLSignatureElement(XMLSignature a_parent, Element a_element, IMyPrivateKey a_signKey, byte[] a_digestValue) throws Exception {
        this(a_parent);
        this.createSignatureElement(a_signKey, a_element, a_digestValue);
    }

    protected XMLSignatureElement(XMLSignature a_parent, Element a_element) throws XMLParseException {
        if (a_element == null || !a_element.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException("##__root__##", "This is no signature element!");
        }
        this.m_parent = a_parent;
        this.m_elemSignature = a_element;
        this.findCertificates(this.m_elemSignature);
        Node node = XMLUtil.getFirstChildByName(this.m_elemSignature, ELEM_SIGNED_INFO);
        if (node == null) {
            this.m_signedInfoCanonical = XMLSignature.toCanonicalDeprecated(this.m_elemSignature);
            if (this.m_signedInfoCanonical == null) {
                throw new XMLParseException(ELEM_SIGNED_INFO);
            }
        } else {
            this.m_signedInfoCanonical = XMLSignature.toCanonical(node);
            Node subnode = XMLUtil.getFirstChildByName(node, ELEM_SIGNATURE_METHOD);
            this.m_signatureMethod = XMLUtil.parseValue(subnode, "");
            if ((node = XMLUtil.getFirstChildByName(node, ELEM_REFERENCE)) == null) {
                throw new XMLParseException(ELEM_REFERENCE);
            }
            this.m_referenceURI = XMLUtil.parseAttribute((Node)((Element)node), ATTR_URI, "");
            subnode = XMLUtil.getFirstChildByName(node, ELEM_DIGEST_METHOD);
            this.m_digestMethod = XMLUtil.parseValue(subnode, "");
            if ((node = XMLUtil.getFirstChildByName(node, ELEM_DIGEST_VALUE)) == null) {
                throw new XMLParseException(ELEM_DIGEST_VALUE);
            }
            this.m_digestValue = XMLUtil.parseValue(node, "");
        }
        if ((node = XMLUtil.getFirstChildByName(this.m_elemSignature, ELEM_SIGNATURE_VALUE)) == null) {
            throw new XMLParseException(ELEM_SIGNATURE_VALUE);
        }
        this.m_signatureValue = XMLUtil.parseValue(node, "");
    }

    private void createSignatureElement(IMyPrivateKey a_signKey, Element a_elementToSign, byte[] a_digestValue) throws Exception {
        this.m_referenceURI = "";
        this.m_digestMethod = DIGEST_METHOD_ALGORITHM;
        this.m_digestValue = new String(Base64.encode(a_digestValue, false));
        Document doc = a_elementToSign.getOwnerDocument();
        Element signedInfoNode = doc.createElement(ELEM_SIGNED_INFO);
        Element canonicalizationNode = doc.createElement(ELEM_CANONICALIZATION_METHOD);
        Element signatureMethodNode = doc.createElement(ELEM_SIGNATURE_METHOD);
        String signatureMethod = a_signKey.getSignatureAlgorithm().getXMLSignatureAlgorithmReference();
        if (signatureMethod != null) {
            this.m_signatureMethod = signatureMethod;
            XMLUtil.setAttribute(signatureMethodNode, ATTR_ALGORITHM, signatureMethod);
        } else {
            this.m_signatureMethod = "";
        }
        Element referenceNode = doc.createElement(ELEM_REFERENCE);
        if (this.m_referenceURI.length() > 0) {
            referenceNode.setAttribute(ATTR_URI, this.m_referenceURI);
        }
        Element digestMethodNode = doc.createElement(ELEM_DIGEST_METHOD);
        XMLUtil.setAttribute(digestMethodNode, ATTR_ALGORITHM, DIGEST_METHOD_ALGORITHM);
        Element digestValueNode = doc.createElement(ELEM_DIGEST_VALUE);
        XMLUtil.setValue((Node)digestValueNode, this.m_digestValue);
        referenceNode.appendChild(digestMethodNode);
        referenceNode.appendChild(digestValueNode);
        signedInfoNode.appendChild(canonicalizationNode);
        signedInfoNode.appendChild(signatureMethodNode);
        signedInfoNode.appendChild(referenceNode);
        this.m_signedInfoCanonical = XMLSignature.toCanonical(signedInfoNode);
        byte[] signatureValue = ByteSignature.sign(this.m_signedInfoCanonical, a_signKey);
        signatureValue = a_signKey.getSignatureAlgorithm().encodeForXMLSignature(signatureValue);
        if (signatureValue == null) {
            throw new Exception();
        }
        this.m_signatureValue = new String(Base64.encode(signatureValue, false));
        Element signatureValueNode = doc.createElement(ELEM_SIGNATURE_VALUE);
        signatureValueNode.appendChild(doc.createTextNode(this.m_signatureValue));
        Element signatureNode = doc.createElement(XML_ELEMENT_NAME);
        signatureNode.appendChild(signedInfoNode);
        signatureNode.appendChild(signatureValueNode);
        a_elementToSign.appendChild(signatureNode);
        this.m_elemSignature = signatureNode;
    }

    private synchronized void findCertificates(Element a_xmlSignature) {
        this.m_appendedCerts = new Vector();
        this.m_appendedCertXMLElements = new Vector();
        Element elemContainer = (Element)XMLUtil.getFirstChildByName(a_xmlSignature, ELEM_KEY_INFO);
        if (elemContainer == null) {
            return;
        }
        if ((elemContainer = (Element)XMLUtil.getFirstChildByName(elemContainer, "X509Data")) == null) {
            return;
        }
        Node nodeCertificate = XMLUtil.getFirstChildByName(elemContainer, "X509Certificate");
        while (nodeCertificate != null) {
            try {
                JAPCertificate currentCertificate = JAPCertificate.getInstance(nodeCertificate);
                if (currentCertificate != null) {
                    this.m_appendedCerts.addElement(currentCertificate);
                    this.m_appendedCertXMLElements.addElement(nodeCertificate);
                }
            }
            catch (ClassCastException a_e) {
                // empty catch block
            }
            nodeCertificate = XMLUtil.getNextSibling(nodeCertificate);
        }
    }

    public boolean verifyFast(Node a_node, IMyPublicKey a_publicKey) throws XMLParseException {
        boolean bResult = this.verify(a_node, a_publicKey);
        if (XMLUtil.getStorageMode() == 2) {
            this.m_elemSignature = null;
            this.m_signedInfoCanonical = null;
        }
        return bResult;
    }

    public boolean verify(Node a_node, int a_documentType, Vector a_directCertPaths) throws XMLParseException {
        if (this.m_appendedCerts.size() > 0) {
            Enumeration certificates = this.m_appendedCerts.elements();
            while (certificates.hasMoreElements()) {
                JAPCertificate currentCertificate = (JAPCertificate)certificates.nextElement();
                if (!this.verify(a_node, currentCertificate.getPublicKey())) continue;
                Vector appendedCertificates = (Vector)this.getCertificates().clone();
                appendedCertificates.removeElement(currentCertificate);
                this.m_certPath = CertPath.getInstance(currentCertificate, a_documentType, appendedCertificates);
                if (XMLUtil.getStorageMode() == 2) {
                    this.m_elemSignature = null;
                    this.m_signedInfoCanonical = null;
                }
                return true;
            }
        } else {
            Enumeration certificates = a_directCertPaths.elements();
            while (certificates.hasMoreElements()) {
                CertPath currentPath = (CertPath)certificates.nextElement();
                if (!this.verify(a_node, currentPath.getFirstCertificate().getPublicKey())) continue;
                this.m_certPath = currentPath;
                if (XMLUtil.getStorageMode() == 2) {
                    this.m_elemSignature = null;
                    this.m_signedInfoCanonical = null;
                }
                return true;
            }
        }
        if (XMLUtil.getStorageMode() == 2) {
            this.m_elemSignature = null;
            this.m_signedInfoCanonical = null;
        }
        return false;
    }

    private boolean verify(Node a_node, IMyPublicKey a_publicKey) throws XMLParseException {
        if (a_publicKey == null || a_node == null) {
            return false;
        }
        if (!this.checkMessageDigest(a_node)) {
            return false;
        }
        return this.checkSignature(a_publicKey);
    }

    private boolean checkSignature(IMyPublicKey a_publicKey) {
        byte[] buff = Base64.decode(this.m_signatureValue);
        buff = a_publicKey.getSignatureAlgorithm().decodeForXMLSignature(buff);
        if (buff == null) {
            return false;
        }
        return ByteSignature.verify(this.m_signedInfoCanonical, buff, a_publicKey);
    }

    private boolean checkMessageDigest(Node a_node) throws XMLParseException {
        if (this.m_digestMethod == null) {
            return true;
        }
        SHA1Digest sha1 = new SHA1Digest();
        byte[] digest = new byte[sha1.getDigestSize()];
        byte[] buff = XMLSignature.toCanonical(a_node, this.m_parent.getSignatureElements());
        sha1.update(buff, 0, buff.length);
        sha1.doFinal(digest, 0);
        return Util.arraysEqual(Base64.decode(this.m_digestValue), digest);
    }

    protected Element getSignatureElement() {
        return this.m_elemSignature;
    }

    public String getSignatureMethod() {
        return this.m_signatureMethod;
    }

    public String getDigestMethod() {
        return this.m_digestMethod;
    }

    public String getReferenceURI() {
        return this.m_referenceURI.trim();
    }

    public CertPath getCertPath() {
        return this.m_certPath;
    }

    private synchronized Vector getCertificates() {
        Vector certificates = new Vector(this.m_appendedCerts.size());
        Enumeration enumCerts = this.m_appendedCerts.elements();
        while (enumCerts.hasMoreElements()) {
            certificates.addElement(enumCerts.nextElement());
        }
        return certificates;
    }

    public synchronized boolean containsCertificate(JAPCertificate a_certificate) {
        return this.m_appendedCerts.contains(a_certificate);
    }

    public synchronized int countCertificates() {
        return this.m_appendedCerts.size();
    }

    public synchronized void clearCertificates() {
        Enumeration certificates = this.m_appendedCertXMLElements.elements();
        while (certificates.hasMoreElements()) {
            Element currentElemCertificate = (Element)certificates.nextElement();
            Node parentNode = currentElemCertificate.getParentNode();
            if (parentNode == null) continue;
            parentNode.removeChild(currentElemCertificate);
        }
        this.m_appendedCertXMLElements.removeAllElements();
        this.m_appendedCerts.removeAllElements();
    }

    public synchronized boolean removeCertificate(JAPCertificate a_certificate) {
        int index = this.m_appendedCerts.indexOf(a_certificate);
        if (index >= 0) {
            this.m_appendedCerts.removeElementAt(index);
            if (index >= this.m_appendedCertXMLElements.size()) {
                this.m_appendedCertXMLElements.removeElementAt(index);
                return true;
            }
        }
        return false;
    }

    public synchronized boolean addCertificate(JAPCertificate a_certificate) {
        Node nodeCertificateContainer;
        if (a_certificate == null) {
            return false;
        }
        Node nodeKeyInfo = XMLUtil.getFirstChildByName(this.m_elemSignature, ELEM_KEY_INFO);
        if (nodeKeyInfo == null) {
            nodeKeyInfo = this.m_elemSignature.getOwnerDocument().createElement(ELEM_KEY_INFO);
            this.m_elemSignature.appendChild(nodeKeyInfo);
        }
        if ((nodeCertificateContainer = XMLUtil.getFirstChildByName(nodeKeyInfo, "X509Data")) == null) {
            nodeCertificateContainer = this.m_elemSignature.getOwnerDocument().createElement("X509Data");
            nodeKeyInfo.appendChild(nodeCertificateContainer);
        }
        if (this.m_appendedCerts.contains(a_certificate) || !this.checkSignature(a_certificate.getPublicKey())) {
            return false;
        }
        Element elemCertificate = a_certificate.toXmlElement(this.m_elemSignature.getOwnerDocument());
        this.m_appendedCerts.addElement(a_certificate);
        this.m_appendedCertXMLElements.addElement(elemCertificate);
        nodeCertificateContainer.appendChild(elemCertificate);
        return true;
    }

    public Element toXmlElement(Document a_doc) {
        Element elemSignature = this.toXmlElementInternal(a_doc);
        if (elemSignature != null && this.m_elemSignature == elemSignature) {
            elemSignature = (Element)elemSignature.cloneNode(true);
        }
        return elemSignature;
    }

    private Element toXmlElementInternal(Document a_doc) {
        if (XMLUtil.getStorageMode() == 2 && this.m_elemSignature == null) {
            return null;
        }
        if (this.m_elemSignature.getOwnerDocument() == a_doc) {
            return this.m_elemSignature;
        }
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_elemSignature, true);
        }
        catch (Exception a_e) {
            return null;
        }
    }
}

