/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls;

import anon.crypto.tinytls.AbstractTLSRecord;
import anon.crypto.tinytls.TLSHandshakeRecord;
import anon.crypto.tinytls.TinyTLS;

public final class TLSPlaintextRecord
extends AbstractTLSRecord {
    static final int TYPE_CHANGE_CIPHER_SPEC = 20;
    static final int TYPE_ALERT = 21;
    static final int TYPE_HANDSHAKE = 22;
    static final int TYPE_APPLICATION_DATA = 23;
    static final int CHANGE_CIPHER_SPEC_TYPE_CHANGED = 1;
    static final int CHANGE_CIPHER_SPEC_LENGTH = 1;
    static final int ALERT_LEVEL_WARNING = 1;
    static final int ALERT_LEVEL_FATAL = 2;
    static final int ALERT_TYPE_CLOSE_NOTIFY = 0;
    static final int ALERT_LENGTH = 2;
    public static final int HEADER_LENGTH = 5;
    public static final int MAX_PAYLOAD_SIZE = 16384;
    private int m_nextHandshakeRecordOffset;

    public TLSPlaintextRecord() {
        this.m_Header = new byte[5];
        this.m_Header[1] = TinyTLS.PROTOCOLVERSION[0];
        this.m_Header[2] = TinyTLS.PROTOCOLVERSION[1];
        this.m_Data = new byte[16384];
        this.m_dataLen = 0;
        this.m_Type = 0;
        this.m_nextHandshakeRecordOffset = 0;
    }

    public void clean() {
        this.m_dataLen = 0;
        this.m_Type = 0;
        this.m_nextHandshakeRecordOffset = 0;
    }

    public int getHeaderLength() {
        return 5;
    }

    public int getMaxPayloadSize() {
        return 16384;
    }

    public void setLength(int len) {
        this.m_dataLen = len;
        this.m_Header[3] = (byte)(len >> 8 & 0xFF);
        this.m_Header[4] = (byte)(len & 0xFF);
    }

    public boolean hasMoreHandshakeRecords() {
        return this.m_Type == 22 && this.m_nextHandshakeRecordOffset < this.m_dataLen;
    }

    public TLSHandshakeRecord getNextHandshakeRecord() {
        TLSHandshakeRecord handshake = new TLSHandshakeRecord(this.m_Data, this.m_nextHandshakeRecordOffset);
        this.m_nextHandshakeRecordOffset += handshake.getLength() + 4;
        return handshake;
    }
}

