/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLMixInfo
implements IXMLEncodable {
    private String m_mixCert;
    private int m_balance;
    private Timestamp m_updateTime;
    private int m_operatorId;
    private int m_id;
    private Document m_docTheMixInfo;

    public XMLMixInfo(String mixCert, int balance, Timestamp updateTime, int operatorId, int id) {
        this.m_mixCert = mixCert;
        this.m_updateTime = updateTime;
        this.m_balance = balance;
        this.m_updateTime = updateTime;
        this.m_operatorId = operatorId;
        this.m_id = id;
        this.m_docTheMixInfo = XMLUtil.createDocument();
    }

    public XMLMixInfo(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheMixInfo = doc;
    }

    public XMLMixInfo(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheMixInfo = doc;
    }

    public XMLMixInfo(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheMixInfo = XMLUtil.createDocument();
        this.m_docTheMixInfo.appendChild(XMLUtil.importNode(this.m_docTheMixInfo, xml, true));
    }

    private void setValues(Element xml) throws Exception {
        if (!xml.getTagName().equals("MixInfo")) {
            throw new Exception("XMLMixInfo: cannot parse, wrong xml format!");
        }
        if (!xml.getAttribute("version").equals("1.0")) {
            throw new Exception("XMLMixInfo: cannot parse, cert version is " + xml.getAttribute("version") + " but 1.0 was expected.");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, "MixCert");
        this.m_mixCert = XMLUtil.parseValue((Node)elem, "error");
        if (this.m_mixCert.equals("error")) {
            throw new Exception("XMLMixInfo: cannot parse the MixCertificate");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "Balance");
        this.m_balance = XMLUtil.parseValue((Node)elem, -1000);
        if (this.m_balance == -1000) {
            throw new Exception("XMLMixInfo: cannot parse balance");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "updateTime");
        String timestamp = XMLUtil.parseValue((Node)elem, "0");
        this.m_updateTime = Timestamp.valueOf(timestamp);
        elem = (Element)XMLUtil.getLastChildByName(xml, "operatorId");
        this.m_operatorId = XMLUtil.parseValue((Node)elem, -1);
        if (this.m_operatorId == -1) {
            throw new Exception("XMLMixInfo: cannot parse operator id");
        }
        elem = (Element)XMLUtil.getLastChildByName(xml, "id");
        this.m_id = XMLUtil.parseValue((Node)elem, -1);
        if (this.m_id == -1) {
            throw new Exception("XMLMixInfo: cannot parse id");
        }
    }

    public Timestamp getUpdateTime() {
        return this.m_updateTime;
    }

    public int getBalance() {
        return this.m_balance;
    }

    public String getMixCert() {
        return this.m_mixCert;
    }

    public int getOperatorId() {
        return this.m_operatorId;
    }

    public int getId() {
        return this.m_id;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheMixInfo.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

