/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.proxy.AnonProxyRequest;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackBuffer;
import anon.proxy.ProxyCallbackDelayException;
import anon.proxy.ProxyCallbackNotProcessableException;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyCallbackHandler {
    private Vector callbacks = new Vector();

    public void deliverUpstream(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException, ProxyCallbackDelayException {
        int currentStatus = 2;
        ProxyCallback[] currentCallbacks = this.toArray();
        if (currentCallbacks != null) {
            for (int i = 0; i < currentCallbacks.length; ++i) {
                currentStatus = currentCallbacks[i].handleUpstreamChunk(anonRequest, buffer);
                if (currentStatus == 1) {
                    throw new ProxyCallbackDelayException();
                }
                if (currentStatus == 0) break;
            }
        }
    }

    public void deliverDownstream(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException, ProxyCallbackDelayException {
        if (anonRequest == null) {
            throw new NullPointerException("AnonProxyRequest must not be null!");
        }
        int currentStatus = 2;
        ProxyCallback[] currentCallbacks = this.toArray();
        if (currentCallbacks != null) {
            for (int i = 0; i < currentCallbacks.length; ++i) {
                currentStatus = currentCallbacks[i].handleDownstreamChunk(anonRequest, buffer);
                if (currentStatus == 1) {
                    throw new ProxyCallbackDelayException();
                }
                if (currentStatus == 0) break;
            }
        }
    }

    public synchronized void closeRequest(AnonProxyRequest anonRequest) {
        if (anonRequest == null) {
            throw new NullPointerException("AnonProxyRequest must not be null!");
        }
        Enumeration enumeration = this.callbacks.elements();
        while (enumeration.hasMoreElements()) {
            ProxyCallback callback = (ProxyCallback)enumeration.nextElement();
            callback.closeRequest(anonRequest);
        }
    }

    private synchronized ProxyCallback[] toArray() {
        ProxyCallback[] currentCallbacks = new ProxyCallback[this.callbacks.size()];
        for (int i = 0; i < currentCallbacks.length; ++i) {
            currentCallbacks[i] = (ProxyCallback)this.callbacks.elementAt(i);
        }
        return currentCallbacks;
    }

    public synchronized void registerProxyCallback(ProxyCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.addElement(callback);
        }
    }

    public synchronized void removeCallback(ProxyCallback callback) {
        this.callbacks.removeElement(callback);
    }
}

