/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

public class ObjectQueue {
    private QueueItem m_head = null;
    private QueueItem m_foot = null;
    private int m_size = 0;
    private volatile boolean m_bClosed;

    public int getSize() {
        return this.m_size;
    }

    public void close() {
        this.m_bClosed = true;
    }

    public synchronized void push(Object a_object) {
        QueueItem newItem = new QueueItem(a_object);
        ++this.m_size;
        if (this.m_head == null) {
            this.m_head = newItem;
            this.m_foot = newItem;
        } else {
            this.m_head.m_previous = newItem;
            this.m_head = newItem;
        }
    }

    public synchronized Object pop() {
        Object object;
        if (this.m_head == null) {
            return null;
        }
        if (this.m_head == this.m_foot) {
            object = this.m_foot.m_object;
            this.m_head = null;
            this.m_foot = null;
        } else {
            object = this.m_foot.m_object;
            this.m_foot = this.m_foot.m_previous;
        }
        --this.m_size;
        return object;
    }

    public Object take() {
        while (!this.m_bClosed) {
            Object o = this.pop();
            if (o != null) {
                return o;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return null;
    }

    public Object poll(int a_msTimeout) throws InterruptedException {
        Object o = this.pop();
        if (o != null) {
            return o;
        }
        Thread.sleep(a_msTimeout);
        return this.pop();
    }

    public synchronized boolean isEmpty() {
        return this.m_size == 0;
    }

    private final class QueueItem {
        private Object m_object;
        private QueueItem m_previous = null;

        public QueueItem(Object a_object) {
            this.m_object = a_object;
            ObjectQueue.this.m_bClosed = false;
        }
    }
}

