/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Friend;
import com.skype.SkypeException;
import com.skype.SkypeObject;
import com.skype.Utils;
import java.util.Hashtable;

public class User
extends SkypeObject {
    private static final Hashtable users = new Hashtable();
    public static final String STATUS_PROPERTY = "status";
    public static final String MOOD_TEXT_PROPERTY = "moodText";
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getInstance(String id) {
        Hashtable hashtable = users;
        synchronized (hashtable) {
            if (!users.containsKey(id)) {
                users.put(id, new User(id));
            }
            return (User)users.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Friend getFriendInstance(String id) {
        Hashtable hashtable = users;
        synchronized (hashtable) {
            if (!users.containsKey(id)) {
                Friend friend = new Friend(id);
                users.put(id, friend);
                return friend;
            }
            User user = (User)users.get(id);
            if (user instanceof Friend) {
                return (Friend)user;
            }
            Friend friend = new Friend(id);
            friend.copyFrom(user);
            users.put(id, friend);
            return friend;
        }
    }

    User(String newId) {
        this.id = newId;
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object compared) {
        if (compared instanceof User) {
            User comparedUser = (User)compared;
            return this.getId().equals(comparedUser.getId());
        }
        return false;
    }

    public final String toString() {
        return this.getId();
    }

    public final String getId() {
        return this.id;
    }

    public final String getFullName() throws SkypeException {
        return this.getProperty("FULLNAME");
    }

    public final String getLauguage() throws SkypeException {
        return this.getLanguage();
    }

    public final String getLanguage() throws SkypeException {
        String value = this.getProperty("LANGUAGE");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(value.indexOf(32) + 1);
    }

    public final String getLanguageByISOCode() throws SkypeException {
        String value = this.getProperty("LANGUAGE");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(0, value.indexOf(32));
    }

    public final String getCountry() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(value.indexOf(32) + 1);
    }

    public final String getCountryByISOCode() throws SkypeException {
        String value = this.getProperty("COUNTRY");
        if ("".equals(value)) {
            return "";
        }
        return value.substring(0, value.indexOf(32));
    }

    public final String getProvince() throws SkypeException {
        return this.getProperty("PROVINCE");
    }

    public final String getCity() throws SkypeException {
        return this.getProperty("CITY");
    }

    public final String getHomePhone() throws SkypeException {
        return this.getHomePhoneNumber();
    }

    public final String getHomePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_HOME");
    }

    public final String getOfficePhone() throws SkypeException {
        return this.getOfficePhoneNumber();
    }

    public final String getOfficePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_OFFICE");
    }

    public final String getMobilePhone() throws SkypeException {
        return this.getMobilePhoneNumber();
    }

    public final String getMobilePhoneNumber() throws SkypeException {
        return this.getProperty("PHONE_MOBILE");
    }

    public final String getHomePageAddress() throws SkypeException {
        return this.getProperty("HOMEPAGE");
    }

    public final String getAbout() throws SkypeException {
        return this.getIntroduction();
    }

    public final String getIntroduction() throws SkypeException {
        return this.getProperty("ABOUT");
    }

    public String getMoodMessage() throws SkypeException {
        return this.getProperty("MOOD_TEXT");
    }

    public String getSpeedDial() throws SkypeException {
        return this.getProperty("SPEEDDIAL");
    }

    public void getSpeedDial(String newValue) throws SkypeException {
        this.setProperty("SPEEDDIAL", newValue);
    }

    public int getTimeZone() throws SkypeException {
        return Integer.parseInt(this.getProperty("TIMEZONE"));
    }

    public final String getDisplayName() throws SkypeException {
        return this.getProperty("DISPLAYNAME");
    }

    public final boolean isVideoCapable() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_VIDEO_CAPABLE"));
    }

    public final boolean isAuthorized() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISAUTHORIZED"));
    }

    public final void setAuthorized(boolean on) throws SkypeException {
        this.setProperty("ISAUTHORIZED", on);
    }

    public final boolean isBlocked() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("ISBLOCKED"));
    }

    public final boolean canLeaveVoiceMail() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("CAN_LEAVE_VM"));
    }

    public final boolean isForwardingCalls() throws SkypeException {
        return Boolean.parseBoolean(this.getProperty("IS_CF_ACTIVE"));
    }

    public final void setBlocked(boolean on) throws SkypeException {
        this.setProperty("ISBLOCKED", on);
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("USER", this.getId(), name);
    }

    private void setProperty(String name, boolean newValue) throws SkypeException {
        this.setProperty(name, ("" + newValue).toUpperCase());
    }

    private void setProperty(String name, String newValue) throws SkypeException {
        Utils.setProperty("USER", this.getId(), name, newValue);
    }

    public final void setDisplayName(String newValue) throws SkypeException {
        Utils.setProperty("USER", this.getId(), "DISPLAYNAME", newValue);
    }

    final void dispose() {
        users.remove(this.getId());
    }
}

