/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.infoservice.JavaVersionDBEntry;
import gui.GUIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Random;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupMenu {
    private ExitHandler m_exitHandler;
    private Component m_popup;
    private GridBagConstraints m_constraints;
    private Window m_parent;
    private boolean m_bParentOnTop = false;
    private Vector m_popupListeners;
    private Vector m_registeredComponents;
    private boolean m_bCompatibilityMode;

    public PopupMenu() {
        this(new JPopupMenu());
    }

    public PopupMenu(boolean a_bCompatibilityMode) {
        this(new JPopupMenu(), a_bCompatibilityMode);
    }

    public PopupMenu(JPopupMenu a_popup) {
        this(a_popup, false);
    }

    private PopupMenu(JPopupMenu a_popup, boolean a_bCompatibilityMode) {
        if (a_popup == null) {
            throw new IllegalArgumentException("Given argument is null!");
        }
        this.m_bCompatibilityMode = a_bCompatibilityMode;
        if (this.m_bCompatibilityMode) {
            this.m_popup = new JWindow();
            JPanel contentPane = new JPanel();
            contentPane.setBorder(new JPopupMenu().getBorder());
            ((JWindow)this.m_popup).setContentPane(contentPane);
            ((JWindow)this.m_popup).getContentPane().setLayout(new GridBagLayout());
            this.m_popup.addComponentListener(new ComponentAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void componentHidden(ComponentEvent a_event) {
                    Vector vector = PopupMenu.this.m_popupListeners;
                    synchronized (vector) {
                        for (int i = 0; i < PopupMenu.this.m_popupListeners.size(); ++i) {
                            ((PopupMenuListener)PopupMenu.this.m_popupListeners.elementAt(i)).popupMenuWillBecomeInvisible(new PopupMenuEvent(a_event.getSource()));
                        }
                    }
                }
            });
        } else {
            this.m_popup = a_popup;
            a_popup.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent a_event) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent a_event) {
                    PopupMenu.this.resetParentOnTopAttribute();
                }

                public void popupMenuCanceled(PopupMenuEvent a_event) {
                }
            });
            a_popup.addMouseMotionListener(new MouseMotionAdapter(){});
        }
        this.m_popupListeners = new Vector();
        this.m_registeredComponents = new Vector();
        this.m_constraints = new GridBagConstraints();
        this.m_constraints.gridx = 0;
        this.m_constraints.gridy = 0;
        this.m_constraints.weighty = 1.0;
        this.m_constraints.fill = 2;
        this.m_constraints.anchor = 17;
        this.m_popup.setName(Double.toString(new Random().nextDouble()));
        MouseAdapter exitAdapter = new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                ExitHandler handler = PopupMenu.this.m_exitHandler;
                if (handler != null) {
                    handler.exited();
                }
            }

            public void mouseClicked(MouseEvent a_event) {
                if (SwingUtilities.isRightMouseButton(a_event)) {
                    PopupMenu.this.dispose();
                }
            }
        };
        this.m_popup.addMouseListener(exitAdapter);
        this.registerExitHandler(null);
    }

    protected void removeAll() {
        if (this.m_bCompatibilityMode) {
            ((JWindow)this.m_popup).getContentPane().removeAll();
            this.m_constraints.gridy = 0;
            this.m_registeredComponents.removeAllElements();
        } else {
            ((JPopupMenu)this.m_popup).removeAll();
        }
    }

    protected void insert(Component a_component, int a_index) {
        if (this.m_bCompatibilityMode) {
            this.add(a_component);
        } else {
            ((JPopupMenu)this.m_popup).insert(a_component, a_index);
        }
    }

    protected void addSeparator() {
        this.addSeparator(new JSeparator());
    }

    protected void addSeparator(JSeparator a_separator) {
        this.add(a_separator);
        ++this.m_constraints.gridy;
    }

    protected void pack() {
        if (this.m_bCompatibilityMode) {
            ((JWindow)this.m_popup).pack();
        } else {
            ((JPopupMenu)this.m_popup).pack();
        }
    }

    protected void add(Component a_component) {
        if (this.m_bCompatibilityMode) {
            if (a_component == null) {
                return;
            }
            ((JWindow)this.m_popup).getContentPane().add(a_component, this.m_constraints);
            ++this.m_constraints.gridy;
            this.m_registeredComponents.addElement(a_component);
        } else {
            ((JPopupMenu)this.m_popup).add(a_component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPopupMenuListener(PopupMenuListener a_listener) {
        Vector vector = this.m_popupListeners;
        synchronized (vector) {
            if (this.m_bCompatibilityMode) {
                if (a_listener != null && !this.m_popupListeners.contains(a_listener)) {
                    this.m_popupListeners.addElement(a_listener);
                }
            } else {
                ((JPopupMenu)this.m_popup).addPopupMenuListener(a_listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removePopupMenuListener(PopupMenuListener a_listener) {
        Vector vector = this.m_popupListeners;
        synchronized (vector) {
            if (this.m_bCompatibilityMode) {
                if (a_listener != null) {
                    return this.m_popupListeners.removeElement(a_listener);
                }
            } else {
                ((JPopupMenu)this.m_popup).removePopupMenuListener(a_listener);
            }
        }
        return false;
    }

    public Component getParent() {
        return this.m_popup;
    }

    public final Point getRelativePosition(Point a_pointOnScreen) {
        return GUIUtils.getRelativePosition(a_pointOnScreen, this.m_popup);
    }

    public final Point getMousePosition() {
        return GUIUtils.getMousePosition(this.m_popup);
    }

    public final void registerExitHandler(ExitHandler a_exitHandler) {
        this.m_exitHandler = a_exitHandler != null ? a_exitHandler : new ExitHandler(){

            public void exited() {
            }
        };
    }

    public final synchronized void show(Component a_parent, Point a_pointOnScreen) {
        this.show(a_parent, null, a_pointOnScreen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void show(Component a_parent, Window a_hiddenParent, Point a_pointOnScreen) {
        Point location = this.calculateLocationOnScreen(a_parent, a_pointOnScreen);
        Window parentWindow = GUIUtils.getParentWindow(a_parent);
        this.m_popup.setLocation(location);
        this.pack();
        this.m_parent = null;
        this.m_bParentOnTop = false;
        if (GUIUtils.isAlwaysOnTop(a_hiddenParent)) {
            this.m_bParentOnTop = true;
            this.m_parent = a_hiddenParent;
        } else if (GUIUtils.isAlwaysOnTop(parentWindow)) {
            this.m_bParentOnTop = true;
            this.m_parent = parentWindow;
        }
        if (!(this.m_bCompatibilityMode || JavaVersionDBEntry.CURRENT_JAVA_VENDOR.toLowerCase().indexOf("sun") < 0 && JavaVersionDBEntry.CURRENT_JAVA_VENDOR.toLowerCase().indexOf("apple") < 0)) {
            ((JPopupMenu)this.m_popup).setInvoker(parentWindow);
        }
        if (this.m_bCompatibilityMode) {
            Vector vector = this.m_popupListeners;
            synchronized (vector) {
                for (int i = 0; i < this.m_popupListeners.size(); ++i) {
                    ((PopupMenuListener)this.m_popupListeners.elementAt(i)).popupMenuWillBecomeVisible(new PopupMenuEvent(this.m_popup));
                }
            }
        }
        this.setVisible(true);
        if (parentWindow != null && this.m_bParentOnTop) {
            GUIUtils.setAlwaysOnTop(this.m_popup, true);
        }
    }

    public void repaint() {
        this.m_popup.repaint();
    }

    public final void setLocation(Point a_point) {
        this.m_popup.setLocation(a_point);
    }

    public final Point calculateLocationOnScreen(Component a_parent, Point a_pointOnScreen) {
        int x = a_pointOnScreen.x;
        int y = a_pointOnScreen.y;
        GUIUtils.Screen screen = GUIUtils.getCurrentScreen(a_parent);
        Dimension size = this.m_popup.getPreferredSize();
        if (x + size.width > screen.getX() + screen.getWidth()) {
            x = screen.getX() + screen.getWidth() - size.width;
        }
        if (y + size.height > screen.getY() + screen.getHeight()) {
            y = screen.getY() + screen.getHeight() - size.height;
        }
        x = Math.max(x, screen.getX());
        y = Math.max(y, screen.getY());
        return new Point(x, y);
    }

    public final int getWidth() {
        return this.m_popup.getPreferredSize().width;
    }

    public final int getHeight() {
        return this.m_popup.getPreferredSize().height;
    }

    public final boolean isVisible() {
        return this.m_popup.isVisible();
    }

    public final synchronized void dispose() {
        this.setVisible(false);
        if (this.m_bCompatibilityMode) {
            ((JWindow)this.m_popup).dispose();
        }
    }

    private final synchronized void resetParentOnTopAttribute() {
        if (GUIUtils.isAlwaysOnTop(this.m_popup)) {
            GUIUtils.setAlwaysOnTop(this.m_popup, false);
            Window parent = this.m_parent;
            if (parent != null && this.m_bParentOnTop) {
                GUIUtils.setAlwaysOnTop(parent, false);
                parent.setVisible(true);
                GUIUtils.setAlwaysOnTop(parent, true);
            }
            this.m_parent = null;
            this.m_bParentOnTop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void setVisible(boolean a_bVisible) {
        if (!a_bVisible) {
            this.resetParentOnTopAttribute();
        }
        if (a_bVisible && this.m_bCompatibilityMode) {
            Vector vector = this.m_popupListeners;
            synchronized (vector) {
                for (int i = 0; i < this.m_popupListeners.size(); ++i) {
                    ((PopupMenuListener)this.m_popupListeners.elementAt(i)).popupMenuWillBecomeVisible(new PopupMenuEvent(this.m_popup));
                }
            }
        }
        this.m_popup.setVisible(a_bVisible);
    }

    public static interface ExitHandler {
        public void exited();
    }
}

