/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public final class TitledGridBagPanel
extends JPanel {
    private GridBagConstraints m_constraints;
    private Vector m_rows;

    public TitledGridBagPanel() {
        this((String)null);
    }

    public TitledGridBagPanel(String a_strTitle) {
        this(a_strTitle, null);
    }

    public TitledGridBagPanel(String a_strTitle, Insets a_insets) {
        super(new GridBagLayout());
        if (a_strTitle != null) {
            this.setBorder(new TitledBorder(a_strTitle));
        }
        this.m_constraints = new GridBagConstraints();
        this.m_constraints.anchor = 17;
        this.setInsets(a_insets);
        this.m_rows = new Vector();
    }

    public void setInsets(Insets a_insets) {
        if (a_insets == null) {
            a_insets = this.getDefaultInsets();
        }
        this.m_constraints.insets = a_insets;
    }

    public Insets getDefaultInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void removeInsets() {
        this.m_constraints.insets = new Insets(0, 0, 0, 0);
    }

    public void setEnabled(boolean a_bEnabled) {
        if (this.getBorder() instanceof TitledBorder) {
            TitledBorder border = new TitledBorder(((TitledBorder)this.getBorder()).getTitle());
            if (!a_bEnabled) {
                border.setTitleColor(Color.gray);
            }
            this.setBorder(border);
        }
        super.setEnabled(a_bEnabled);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            components[i].setEnabled(a_bEnabled);
        }
    }

    public void setLayout(LayoutManager a_layoutManager) {
        if (!(a_layoutManager instanceof GridBagLayout)) {
            throw new IllegalStateException("Layout is fixed to GridBagLayout!");
        }
        super.setLayout(a_layoutManager);
    }

    public int addRow(Component a_component) {
        return this.addRow(a_component, null);
    }

    public int addRow(Component a_component, Component a_otherComponent) {
        return this.addRow(a_component, a_otherComponent, 2);
    }

    public int addRow(Component a_component, Component a_otherComponent, int a_fill) {
        return this.replaceRow(a_component, a_otherComponent, this.getNextRow(), a_fill);
    }

    public int addRow(Component a_component, Component a_otherComponent, Component a_thirdComponent, Component a_fourthComponent) {
        return this.replaceRow(a_component, a_otherComponent, a_thirdComponent, a_fourthComponent, this.getNextRow());
    }

    public int addRow(Component a_component, Component a_otherComponent, Component a_thirdComponent, Component a_fourthComponent, int a_fill) {
        return this.replaceRow(a_component, a_otherComponent, a_thirdComponent, a_fourthComponent, this.getNextRow(), a_fill);
    }

    public int addRow(Component a_component, Component a_otherComponent, Component a_thirdComponent) {
        return this.replaceRow(a_component, a_otherComponent, a_thirdComponent, this.getNextRow());
    }

    public int addDummyRow() {
        this.m_rows.addElement(new JLabel());
        return this.m_rows.size() - 1;
    }

    public void addDummyRows(int a_rows) {
        while (a_rows > 0) {
            this.m_rows.addElement(new JLabel());
            --a_rows;
        }
    }

    public int addRow(Component[] a_components, int[] a_gridwidths) {
        return this.replaceRow(a_components, a_gridwidths, this.getNextRow());
    }

    public int replaceRow(Component a_component, Component a_otherComponent, int a_rowNumber) {
        return this.replaceRow(a_component, a_otherComponent, a_rowNumber, 2);
    }

    public int replaceRow(Component a_component, Component a_otherComponent, int a_rowNumber, int a_fill) {
        Component[] comps = new Component[]{a_component, a_otherComponent};
        return this.replaceRow(comps, null, a_rowNumber, a_fill);
    }

    public int replaceRow(Component a_component, Component a_otherComponent, Component a_thirdComponent, int a_rowNumber) {
        Component[] comps = new Component[]{a_component, a_otherComponent, a_thirdComponent};
        return this.replaceRow(comps, null, a_rowNumber);
    }

    public int replaceRow(Component a_component, Component a_otherComponent, Component a_thirdComponent, Component a_fourthComponent, int a_rowNumber, int a_fill) {
        Component[] comps = new Component[]{a_component, a_otherComponent, a_thirdComponent, a_fourthComponent};
        return this.replaceRow(comps, null, a_rowNumber, a_fill);
    }

    public int replaceRow(Component a_component, Component a_otherComponent, Component a_thirdComponent, Component a_fourthComponent, int a_rowNumber) {
        return this.replaceRow(a_component, a_otherComponent, a_thirdComponent, a_fourthComponent, a_rowNumber, 2);
    }

    public int getNextRow() {
        return this.m_rows.size();
    }

    public int replaceRow(Component[] a_components, int[] a_gridwidths, int a_rowNumber) {
        return this.replaceRow(a_components, a_gridwidths, a_rowNumber, 2);
    }

    public int replaceRow(Component[] a_components, int[] a_gridwidths, int a_rowNumber, int a_fill) {
        if (a_components != null && a_components.length > 0) {
            int[] gridwidths;
            int i;
            Vector<Component> components = new Vector<Component>();
            for (i = 0; i < a_components.length; ++i) {
                components.addElement(a_components[i]);
            }
            while (this.m_rows.size() < a_rowNumber - 1) {
                this.m_rows.addElement(new Vector());
            }
            if (this.m_rows.size() > a_rowNumber) {
                Vector deletedComponents = (Vector)this.m_rows.elementAt(a_rowNumber);
                for (i = 0; i < deletedComponents.size(); ++i) {
                    this.remove((Component)deletedComponents.elementAt(i));
                }
                this.m_rows.removeElementAt(a_rowNumber);
            }
            this.m_rows.insertElementAt(components, a_rowNumber);
            if (a_gridwidths != null) {
                gridwidths = a_gridwidths;
            } else {
                gridwidths = new int[a_components.length];
                for (i = 0; i < gridwidths.length; ++i) {
                    gridwidths[i] = 1;
                    int currentComponent = i;
                    while (currentComponent + 1 < a_components.length && a_components[currentComponent + 1] == null) {
                        ++currentComponent;
                        int n = i;
                        gridwidths[n] = gridwidths[n] + 1;
                    }
                }
            }
            for (i = 0; i < a_components.length; ++i) {
                if (a_components[i] == null) continue;
                this.m_constraints.gridx = i;
                this.m_constraints.gridy = a_rowNumber;
                this.m_constraints.weightx = 1.0;
                this.m_constraints.gridwidth = gridwidths[i];
                this.m_constraints.weighty = i == a_components.length - 1 ? 10.0 : 0.0;
                this.m_constraints.fill = a_fill;
                this.add(a_components[i], this.m_constraints);
            }
        }
        return a_rowNumber;
    }
}

