/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPHelpContext;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.IDialogOptions;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import gui.help.JAPHelp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.border.TitledBorder;
import logging.LogHolder;
import logging.LogType;

public class DialogContentPane
implements JAPHelpContext.IHelpContext,
IDialogOptions {
    private static final int[] MESSAGE_TYPES = new int[]{-1, 1, 3, 2, 0};
    private static final Icon[] MESSAGE_ICONS = new Icon[MESSAGE_TYPES.length];
    public static final int ON_CLICK_DO_NOTHING = 0;
    public static final int ON_CLICK_HIDE_DIALOG = 1;
    public static final int ON_CLICK_DISPOSE_DIALOG = 2;
    public static final int ON_CLICK_SHOW_NEXT_CONTENT = 4;
    public static final int ON_YESOK_SHOW_NEXT_CONTENT = 8;
    public static final int ON_NO_SHOW_NEXT_CONTENT = 16;
    public static final int ON_CANCEL_SHOW_NEXT_CONTENT = 32;
    public static final int ON_CLICK_SHOW_PREVIOUS_CONTENT = 64;
    public static final int ON_YESOK_SHOW_PREVIOUS_CONTENT = 128;
    public static final int ON_NO_SHOW_PREVIOUS_CONTENT = 256;
    public static final int ON_CANCEL_SHOW_PREVIOUS_CONTENT = 512;
    public static final int ON_YESOK_HIDE_DIALOG = 1024;
    public static final int ON_NO_HIDE_DIALOG = 2048;
    public static final int ON_CANCEL_HIDE_DIALOG = 4096;
    public static final int ON_YESOK_DISPOSE_DIALOG = 8192;
    public static final int ON_NO_DISPOSE_DIALOG = 16384;
    public static final int ON_CANCEL_DISPOSE_DIALOG = 32768;
    public static final int ON_CANCEL_SEND_DIALOG_WINDOW_CLOSING_EVENT = 65536;
    public static final int ON_YESOK_SEND_DIALOG_WINDOW_CLOSING_EVENT = 131072;
    public static final int ON_NO_SEND_DIALOG_WINDOW_CLOSING_EVENT = 262144;
    public static final int ON_CLICK_SEND_DIALOG_WINDOW_CLOSING_EVENT = 524288;
    public static final int BUTTON_OPERATION_WIZARD = 266;
    public static final String MSG_OK;
    public static final String MSG_YES;
    public static final String MSG_NO;
    public static final String MSG_NEXT;
    public static final String MSG_PREVIOUS;
    public static final String MSG_FINISH;
    public static final String MSG_CANCEL;
    public static final String MSG_IGNORE;
    public static final String MSG_CONTINUE;
    public static final String MSG_OPERATION_FAILED;
    public static final String MSG_SEE_FULL_MESSAGE;
    public static final String MSG_OPEN_IN_BROWSER;
    public static final int DEFAULT_BUTTON_EMPTY = 0;
    public static final int DEFAULT_BUTTON_CANCEL = 1;
    public static final int DEFAULT_BUTTON_YES = 2;
    public static final int DEFAULT_BUTTON_OK = 2;
    public static final int DEFAULT_BUTTON_NO = 3;
    public static final int DEFAULT_BUTTON_HELP = 4;
    public static final int DEFAULT_BUTTON_KEEP = 5;
    private static final int MIN_TEXT_WIDTH = 100;
    private static final int UNLIMITED_SIZE = 2500;
    private static final int SPACE_AROUND_TEXT = 5;
    private static final String MORE_POINTS = "...";
    private static final int NUMBER_OF_HEURISTIC_ITERATIONS = 6;
    private static final boolean MOVE_PANE_NEXT = true;
    private static final boolean MOVE_PANE_PREVIOUS = false;
    private DialogContentPane m_nextContentPane;
    private DialogContentPane m_previousContentPane;
    private RootPaneContainer m_parentDialog;
    private JComponent m_contentPane;
    private JPanel m_titlePane;
    private JPanel m_rootPane;
    private Container m_panelOptions;
    private JAPHtmlMultiLineLabel m_lblMessage;
    private MouseListener m_linkedListener;
    private JAPHtmlMultiLineLabel m_lblText;
    private JAPHtmlMultiLineLabel m_lblSeeFullText;
    private int m_defaultButtonOperation;
    private int m_value;
    private JAPHelpContext.IHelpContext m_helpContext;
    private JButton m_btnHelp;
    private JButton m_btnYesOK;
    private JButton m_btnNo;
    private JButton m_btnCancel;
    private ButtonListener m_buttonListener;
    private Icon m_icon;
    private GridBagConstraints m_textConstraints;
    private Vector m_rememberedErrors = new Vector();
    private Vector m_rememberedUpdateErrors = new Vector();
    private Container m_currentlyActiveContentPane;
    private Vector m_componentListeners = new Vector();
    private ComponentListener m_currentlyActiveContentPaneComponentListener;
    private int m_defaultButton;
    private String m_strText;
    private JDialog m_tempDialog;
    private boolean m_bDisposed = false;
    private DialogContentPaneOptions m_options;
    private Layout m_layout;
    private int m_idStatusMessage = 0;
    static /* synthetic */ Class class$gui$dialog$DialogContentPane;

    public DialogContentPane(JDialog a_parentDialog, String a_strText) {
        this((RootPaneContainer)a_parentDialog, a_strText, new Layout(""), null);
    }

    public DialogContentPane(JAPDialog a_parentDialog, String a_strText) {
        this((RootPaneContainer)a_parentDialog, a_strText, new Layout(""), null);
    }

    public DialogContentPane(JDialog a_parentDialog, String a_strText, Layout a_layout) {
        this((RootPaneContainer)a_parentDialog, a_strText, a_layout, null);
    }

    public DialogContentPane(JAPDialog a_parentDialog, String a_strText, Layout a_layout) {
        this((RootPaneContainer)a_parentDialog, a_strText, a_layout, null);
    }

    public DialogContentPane(JDialog a_parentDialog, String a_strText, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, a_strText, new Layout(""), a_options);
    }

    public DialogContentPane(JAPDialog a_parentDialog, String a_strText, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, a_strText, new Layout(""), a_options);
    }

    public DialogContentPane(JDialog a_parentDialog, String a_strText, Layout a_layout, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, a_strText, a_layout, a_options);
    }

    public DialogContentPane(JAPDialog a_parentDialog, String a_strText, Layout a_layout, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, a_strText, a_layout, a_options);
    }

    public DialogContentPane(JDialog a_parentDialog) {
        this((RootPaneContainer)a_parentDialog, null, new Layout(""), null);
    }

    public DialogContentPane(JAPDialog a_parentDialog) {
        this((RootPaneContainer)a_parentDialog, null, new Layout(""), null);
    }

    public DialogContentPane(JDialog a_parentDialog, Layout a_layout) {
        this((RootPaneContainer)a_parentDialog, null, a_layout, null);
    }

    public DialogContentPane(JAPDialog a_parentDialog, Layout a_layout) {
        this((RootPaneContainer)a_parentDialog, null, a_layout, null);
    }

    public DialogContentPane(JDialog a_parentDialog, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, null, new Layout(""), a_options);
    }

    public DialogContentPane(JAPDialog a_parentDialog, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, null, new Layout(""), a_options);
    }

    public DialogContentPane(JDialog a_parentDialog, Layout a_layout, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, null, a_layout, a_options);
    }

    public DialogContentPane(JAPDialog a_parentDialog, Layout a_layout, DialogContentPaneOptions a_options) {
        this((RootPaneContainer)a_parentDialog, null, a_layout, a_options);
    }

    private DialogContentPane(RootPaneContainer a_parentDialog, String a_strText, Layout a_layout, DialogContentPaneOptions a_options) {
        if (a_layout == null) {
            a_layout = new Layout((String)null);
        }
        this.m_layout = a_layout;
        if (a_options == null) {
            a_options = new DialogContentPaneOptions((JAPHelpContext.IHelpContext)null);
        }
        this.m_options = a_options;
        this.m_options.setUpdateCallback(new DialogContentPaneOptions.OptionsUpdateCallback(){

            public void update() {
                String text;
                if (DialogContentPane.this.m_btnYesOK != null && (text = DialogContentPane.this.getButtonYesOKText()) != null) {
                    DialogContentPane.this.m_btnYesOK.setText(text);
                }
                if (DialogContentPane.this.m_btnNo != null && (text = DialogContentPane.this.getButtonNoText()) != null) {
                    DialogContentPane.this.m_btnNo.setText(text);
                }
                if (DialogContentPane.this.m_btnCancel != null && (text = DialogContentPane.this.getButtonCancelText()) != null) {
                    DialogContentPane.this.m_btnCancel.setText(text);
                }
            }
        });
        int a_alignment = 0;
        if (a_parentDialog == null) {
            throw new IllegalArgumentException("The parent dialog must not be null!");
        }
        if (this.m_options.getPreviousContentPane() != null && this.m_options.getPreviousContentPane().m_parentDialog != a_parentDialog) {
            throw new IllegalArgumentException("Chained content panes must refer to the same dialog!");
        }
        if (this.m_options.getOptionType() != Integer.MIN_VALUE && this.m_options.getOptionType() != -1 && this.m_options.getOptionType() != -2147483647 && this.m_options.getOptionType() != 2 && this.m_options.getOptionType() != 1 && this.m_options.getOptionType() != 0) {
            throw new IllegalArgumentException("Unknown option type!");
        }
        if (this.m_layout.getMessageType() != -1 && this.m_layout.getMessageType() != 3 && this.m_layout.getMessageType() != 0 && this.m_layout.getMessageType() != 2 && this.m_layout.getMessageType() != 1) {
            throw new IllegalArgumentException("Unknown message type!");
        }
        this.m_defaultButtonOperation = this instanceof IWizardSuitable ? 266 : 0;
        this.m_parentDialog = a_parentDialog;
        this.m_previousContentPane = this.m_options.getPreviousContentPane();
        this.m_icon = this.m_layout.getIcon();
        if (this.m_icon == null) {
            this.m_icon = DialogContentPane.getMessageIcon(this.m_layout.getMessageType());
        }
        this.m_helpContext = this.m_options.getHelpContext() != null ? (this.m_options.getHelpContext() instanceof JAPHelpContext.IURLHelpContext ? new JAPHelpContext.IURLHelpContext(){

            public Component getHelpExtractionDisplayContext() {
                return DialogContentPane.this.getContentPane();
            }

            public String getHelpContext() {
                return DialogContentPane.this.m_options.getHelpContext().getHelpContext();
            }

            public String getURLMessage() {
                return ((JAPHelpContext.IURLHelpContext)DialogContentPane.this.m_options.getHelpContext()).getURLMessage();
            }

            public URL getHelpURL() {
                return ((JAPHelpContext.IURLHelpContext)DialogContentPane.this.m_options.getHelpContext()).getHelpURL();
            }
        } : new JAPHelpContext.IHelpContext(){

            public Component getHelpExtractionDisplayContext() {
                return DialogContentPane.this.getContentPane();
            }

            public String getHelpContext() {
                return DialogContentPane.this.m_options.getHelpContext().getHelpContext();
            }
        }) : null;
        this.m_rootPane = new JPanel(new BorderLayout());
        this.m_titlePane = new JPanel(new GridBagLayout());
        this.m_rootPane.add((Component)this.m_titlePane, "Center");
        this.addDialogComponentListener(new DialogComponentListener());
        this.addDialogWindowListener(new DialogWindowListener());
        this.setContentPane(new JPanel());
        if (this.m_layout.getTitle() != null) {
            if (this.m_layout.getTitle().trim().length() > 0) {
                this.m_titlePane.setBorder(new TitledBorder(this.m_layout.getTitle()));
            }
            this.m_lblMessage = new JAPHtmlMultiLineLabel();
            this.m_lblMessage.setFontStyle(1);
            this.clearStatusMessage();
            this.m_rootPane.add((Component)this.m_lblMessage, "South");
        }
        if (a_strText != null && a_strText.trim().length() > 0) {
            this.m_strText = JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(a_strText);
            this.m_lblText = new JAPHtmlMultiLineLabel("<font color=#000000>" + this.m_strText + "</font>", a_alignment);
            this.m_lblText.setFontStyle(0);
        }
        this.m_textConstraints = new GridBagConstraints();
        this.m_textConstraints.gridx = 0;
        this.m_textConstraints.gridy = 1;
        this.m_textConstraints.weightx = 1.0;
        this.m_textConstraints.weighty = 0.0;
        this.m_textConstraints.anchor = 11;
        this.m_textConstraints.fill = 2;
        this.m_textConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.m_layout.isCentered()) {
            GridBagConstraints contraints = new GridBagConstraints();
            contraints.gridx = 0;
            contraints.gridy = 0;
            contraints.weightx = 0.0;
            contraints.weighty = 10.0;
            contraints.anchor = 11;
            contraints.fill = 3;
            this.m_titlePane.add((Component)new JPanel(), contraints);
            contraints.gridy = 4;
            this.m_titlePane.add((Component)new JPanel(), contraints);
        }
        if (this.m_previousContentPane != null) {
            this.m_previousContentPane.setNextContentPane(this);
        }
        this.setButtonValue(Integer.MIN_VALUE);
        this.createOptions();
        if (this.m_options.getOptionType() == -1 || this.m_options.getOptionType() == 0 || this.m_options.getOptionType() == 2 || this.m_options.getOptionType() == 1) {
            this.setDefaultButton(2);
        } else if (this.m_options.getOptionType() == -2147483647) {
            this.setDefaultButton(1);
        } else if (this.getButtonHelp() != null) {
            this.setDefaultButton(4);
        } else {
            this.setDefaultButton(5);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent a_event) {
                if (DialogContentPane.this.hasWizardLayout()) {
                    DialogContentPane.this.setTextOfWizardNextButton();
                }
                DialogContentPane.this.validateDialog();
            }
        });
    }

    public static Icon getMessageIcon(int a_messageType) {
        int nrIcon;
        if (a_messageType == 1) {
            nrIcon = 1;
        } else if (a_messageType == 3) {
            nrIcon = 2;
        } else if (a_messageType == 2) {
            nrIcon = 3;
        } else if (a_messageType == 0) {
            nrIcon = 4;
        } else {
            return MESSAGE_ICONS[0];
        }
        Icon icon = MESSAGE_ICONS[nrIcon];
        if (icon == null) {
            DialogContentPane.MESSAGE_ICONS[nrIcon] = icon = DialogContentPane.findMessageIcon(new JOptionPane("", a_messageType));
        }
        return GUIUtils.createScaledIcon(icon, GUIUtils.getIconResizer());
    }

    public void pack() {
        DialogContentPane.pack_internal(this.getFirstContentPane());
    }

    private static void pack_internal(DialogContentPane a_firstContentPane) {
        Accessible dialog;
        if (a_firstContentPane == null) {
            return;
        }
        int maxTextWidth = 100;
        DialogContentPane nextContentPane = a_firstContentPane;
        do {
            maxTextWidth = Math.max(maxTextWidth, nextContentPane.getContentPane().getPreferredSize().width);
        } while ((nextContentPane = nextContentPane.getNextContentPane()) != null);
        int dialogWidth = 0;
        int dialogHeight = 0;
        nextContentPane = a_firstContentPane;
        if (a_firstContentPane.m_parentDialog instanceof JDialog) {
            dialog = (JDialog)a_firstContentPane.m_parentDialog;
            do {
                if (nextContentPane.isDialogVisible()) {
                    throw new IllegalStateException("You may not optimise the dialog size while it is visible!");
                }
                nextContentPane.updateDialog(maxTextWidth, false);
                nextContentPane.m_rootPane.setPreferredSize(null);
                ((Window)dialog).pack();
                dialogWidth = Math.max(dialogWidth, ((Component)((Object)dialog)).getSize().width);
                dialogHeight = Math.max(dialogHeight, ((Component)((Object)dialog)).getSize().height);
            } while ((nextContentPane = nextContentPane.getNextContentPane()) != null);
            ((Window)dialog).setSize(new Dimension(dialogWidth, dialogHeight));
        } else {
            dialog = (JAPDialog)a_firstContentPane.m_parentDialog;
            do {
                if (nextContentPane.isDialogVisible()) {
                    throw new IllegalStateException("You may not optimise the dialog size while it is visible!");
                }
                nextContentPane.updateDialog(maxTextWidth, false);
                nextContentPane.m_rootPane.setPreferredSize(null);
                ((JAPDialog)dialog).pack();
                dialogWidth = Math.max(dialogWidth, ((JAPDialog)dialog).getSize().width);
                dialogHeight = Math.max(dialogHeight, ((JAPDialog)dialog).getSize().height);
            } while ((nextContentPane = nextContentPane.getNextContentPane()) != null);
            ((JAPDialog)dialog).setSize(new Dimension(dialogWidth, dialogHeight));
        }
        nextContentPane = a_firstContentPane;
        do {
            nextContentPane.m_rootPane.setPreferredSize(new Dimension(2500, 2500));
        } while ((nextContentPane = nextContentPane.getNextContentPane()) != null);
        if (a_firstContentPane.isSkippedAsNextContentPane()) {
            if (!a_firstContentPane.moveToNextContentPane()) {
                a_firstContentPane.updateDialog();
            }
        } else {
            a_firstContentPane.updateDialog();
        }
    }

    public final boolean hasPreviousContentPane() {
        DialogContentPane contentPane = this;
        while ((contentPane = contentPane.getPreviousContentPane()) != null) {
            if (!contentPane.isMoveBackAllowed()) {
                return false;
            }
            try {
                if (contentPane.isSkippedAsPreviousContentPane()) continue;
                return true;
            }
            catch (Exception a_e) {
                return false;
            }
        }
        return false;
    }

    public final boolean hasNextContentPane() {
        DialogContentPane contentPane = this;
        while ((contentPane = contentPane.getNextContentPane()) != null) {
            if (!contentPane.isMoveForwardAllowed()) {
                return false;
            }
            try {
                if (contentPane.isSkippedAsNextContentPane()) continue;
                return true;
            }
            catch (Exception a_e) {
                LogHolder.log(3, LogType.GUI, a_e);
                return false;
            }
        }
        return false;
    }

    public final boolean hasWizardLayout() {
        DialogContentPane contentPane = this;
        if (!(contentPane instanceof IWizardSuitable) || this.getNextContentPane() == null && this.getPreviousContentPane() == null) {
            return false;
        }
        while ((contentPane = contentPane.getPreviousContentPane()) != null) {
            if (contentPane instanceof IWizardSuitable) continue;
            return false;
        }
        contentPane = this;
        while ((contentPane = contentPane.getNextContentPane()) != null) {
            if (contentPane instanceof IWizardSuitable) continue;
            return false;
        }
        return this.getNextContentPane() != null || this.getPreviousContentPane() == null || !(this.getPreviousContentPane() instanceof WorkerContentPane) || this.hasPreviousContentPane() || this.getPreviousContentPane().getPreviousContentPane() != null;
    }

    public final DialogContentPane getFirstContentPane() {
        DialogContentPane contentPane = this;
        while (contentPane.getPreviousContentPane() != null) {
            contentPane = contentPane.getPreviousContentPane();
        }
        return contentPane;
    }

    public final DialogContentPane getNextContentPane() {
        return this.m_nextContentPane;
    }

    public final DialogContentPane getPreviousContentPane() {
        return this.m_previousContentPane;
    }

    public final boolean moveToPreviousContentPane() {
        return this.moveToContentPane(false) != this;
    }

    public CheckError checkYesOK() {
        return null;
    }

    public CheckError checkNo() {
        return null;
    }

    public CheckError checkCancel() {
        return null;
    }

    public CheckError checkUpdate() {
        return null;
    }

    public boolean isSkippedAsNextContentPane() {
        return false;
    }

    public boolean isMoveBackAllowed() {
        return true;
    }

    public boolean isMoveForwardAllowed() {
        return true;
    }

    public boolean isSkippedAsPreviousContentPane() {
        return false;
    }

    public final boolean moveToNextContentPane() {
        return this.moveToContentPane(true) != this;
    }

    public final JComponent getContentPane() {
        return this.m_contentPane;
    }

    public final void showDialog() {
        if (this.m_parentDialog instanceof JDialog) {
            ((JDialog)this.m_parentDialog).setVisible(true);
        } else {
            ((JAPDialog)this.m_parentDialog).setVisible(true);
        }
    }

    public final void setContentPane(JComponent a_contentPane) {
        GridBagConstraints contraints = new GridBagConstraints();
        contraints.gridx = 0;
        contraints.gridy = 3;
        contraints.weightx = 1.0;
        contraints.weighty = 1.0;
        contraints.anchor = 11;
        contraints.fill = 1;
        if (this.m_contentPane != null) {
            this.m_titlePane.remove(this.m_contentPane);
        }
        this.m_titlePane.add((Component)a_contentPane, contraints);
        this.m_contentPane = a_contentPane;
    }

    public final String getHelpContext() {
        if (this.m_helpContext == null) {
            return null;
        }
        return this.m_helpContext.getHelpContext();
    }

    public Component getHelpExtractionDisplayContext() {
        if (this.m_helpContext == null) {
            return null;
        }
        return this.m_helpContext.getHelpExtractionDisplayContext();
    }

    public final void clearStatusMessage(int a_messageID) {
        if (this.m_idStatusMessage == a_messageID) {
            this.clearStatusMessage();
        }
    }

    public final void clearStatusMessage() {
        if (this.m_lblMessage != null) {
            this.m_lblMessage.setText("T");
            this.m_lblMessage.setPreferredSize(this.m_lblMessage.getPreferredSize());
            this.m_lblMessage.removeMouseListener(this.m_linkedListener);
            this.m_linkedListener = null;
            this.m_lblMessage.setText("");
            this.m_lblMessage.setToolTipText(null);
        }
    }

    public void doAfterUpdate() {
    }

    public final void printStatusMessage(String a_message) {
        this.printStatusMessage(a_message, 1);
    }

    public final void printStatusMessage(String a_message, int a_messageType) {
        this.printStatusMessage(a_message, a_messageType, null);
    }

    public final void printStatusMessage(String a_message, int a_messageType, URL a_linked) {
        if (this.m_lblMessage != null) {
            this.printStatusMessageInternal(a_message, a_messageType, a_linked);
        } else {
            JAPDialog.showConfirmDialog((Component)this.getContentPane(), a_message, -1, a_messageType);
        }
    }

    public final int printErrorStatusMessage(Throwable a_throwable) {
        return this.printErrorStatusMessage(null, a_throwable);
    }

    public final int printErrorStatusMessage(String a_message) {
        return this.printErrorStatusMessage(a_message, null);
    }

    public final int printErrorStatusMessage(String a_message, Throwable a_throwable) {
        return this.printErrorStatusMessage(a_message, a_throwable, true);
    }

    public final void validateDialog() {
        if (this.getDialog() instanceof JDialog) {
            ((JDialog)this.getDialog()).validate();
        } else {
            ((JAPDialog)this.getDialog()).validate();
        }
    }

    public final synchronized CheckError updateDialog() {
        return this.updateDialog(100, true);
    }

    private final synchronized CheckError updateDialog(boolean a_bCheckUpdate) {
        return this.updateDialog(100, a_bCheckUpdate);
    }

    private int printErrorStatusMessage(String a_message, Throwable a_throwable, boolean a_bShow) {
        boolean bPossibleApplicationError = false;
        int idStatusMessage = 0;
        try {
            a_message = JAPDialog.retrieveErrorMessage(a_message, a_throwable);
            if (a_message == null) {
                a_message = JAPMessages.getString(JAPDialog.MSG_ERROR_UNKNOWN);
                bPossibleApplicationError = true;
            }
            if (this.m_lblMessage != null) {
                if (a_bShow) {
                    idStatusMessage = this.printStatusMessageInternal(a_message, 0);
                }
                LogHolder.log(3, LogType.GUI, a_message, 1);
                if (a_throwable != null) {
                    if (bPossibleApplicationError) {
                        LogHolder.log(3, LogType.GUI, a_throwable);
                    } else {
                        LogHolder.log(7, LogType.GUI, a_throwable);
                    }
                }
            } else if (a_bShow) {
                JAPDialog.showErrorDialog((Component)this.getContentPane(), a_message, a_throwable);
            }
        }
        catch (Throwable a_e) {
            JAPDialog.showErrorDialog((Component)this.getContentPane(), a_e);
        }
        return idStatusMessage;
    }

    private final synchronized CheckError updateDialog(int a_maxTextWidth, boolean a_bCallCheckUpdate) {
        if (this.isDisposed()) {
            return null;
        }
        CheckError errors = a_bCallCheckUpdate ? this.checkUpdate() : null;
        if (errors != null) {
            return errors;
        }
        this.createOptions();
        Object[] options = new Object[]{this.m_panelOptions};
        JOptionPane pane = new JOptionPane(this.m_rootPane, this.m_layout.getMessageType(), 0, this.m_icon, options);
        if (this.m_tempDialog != null) {
            if (Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                return new CheckError("Interrupted!");
            }
            this.m_tempDialog.dispose();
            if (this.m_tempDialog.isDisplayable()) {
                Thread.currentThread().interrupt();
            }
            if (Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                return new CheckError("Interrupted!");
            }
        }
        if (this.m_lblText != null) {
            this.m_titlePane.remove(this.m_lblText);
        }
        this.m_tempDialog = pane.createDialog(null, "");
        this.m_tempDialog.pack();
        if (this.m_lblText != null) {
            if (this.isDialogVisible()) {
                this.m_lblText = new JAPHtmlMultiLineLabel(this.m_lblText.getText(), this.m_lblText.getFont(), 0);
            } else if (this.m_lblText.getPreferredSize().width > this.m_contentPane.getWidth() - 10) {
                this.m_lblText.setPreferredWidth(Math.max(this.m_lblText.getMinimumSize().width, Math.max(this.m_contentPane.getWidth() - 10, a_maxTextWidth)));
            }
            this.m_titlePane.add((Component)this.m_lblText, this.m_textConstraints);
        }
        this.clearStatusMessage();
        this.doAfterUpdate();
        if (this.m_currentlyActiveContentPane != null) {
            this.m_currentlyActiveContentPane.removeComponentListener(this.m_currentlyActiveContentPaneComponentListener);
        }
        this.m_currentlyActiveContentPane = this.m_tempDialog.getContentPane();
        this.m_currentlyActiveContentPaneComponentListener = new ContentPaneComponentListener();
        this.m_currentlyActiveContentPane.addComponentListener(this.m_currentlyActiveContentPaneComponentListener);
        this.m_parentDialog.setContentPane(this.m_currentlyActiveContentPane);
        if (this.isDialogVisible()) {
            Vector listeners = (Vector)this.m_componentListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((ComponentListener)listeners.elementAt(i)).componentShown(new ComponentEvent(this.m_currentlyActiveContentPane, 102));
            }
        }
        if (this.m_defaultButton == 2) {
            this.getDialog().getRootPane().setDefaultButton(this.m_btnYesOK);
        } else if (this.m_defaultButton == 1) {
            this.getDialog().getRootPane().setDefaultButton(this.m_btnCancel);
        } else if (this.m_defaultButton == 3) {
            this.getDialog().getRootPane().setDefaultButton(this.m_btnNo);
        } else if (this.m_defaultButton == 4) {
            this.getDialog().getRootPane().setDefaultButton(this.getButtonHelp());
        } else if (this.m_defaultButton != 5) {
            this.getDialog().getRootPane().setDefaultButton(null);
        }
        this.m_titlePane.invalidate();
        if (this.m_lblText != null) {
            this.m_lblText.invalidate();
        }
        this.m_rootPane.invalidate();
        this.m_contentPane.invalidate();
        if (this.m_parentDialog instanceof JAPDialog) {
            ((JAPDialog)this.m_parentDialog).validate();
        } else {
            ((JDialog)this.m_parentDialog).validate();
        }
        return null;
    }

    protected final JButton getButtonHelp() {
        return this.m_btnHelp;
    }

    protected final JButton getButtonCancel() {
        return this.m_btnCancel;
    }

    protected final JButton getButtonYesOK() {
        return this.m_btnYesOK;
    }

    public void setButtonCancelEnabled(boolean a_bEnable) {
        if (this.m_btnCancel != null) {
            this.m_btnCancel.setEnabled(a_bEnable);
        }
    }

    public boolean hideButtonCancel() {
        return this.hasWizardLayout() && !this.hasNextContentPane();
    }

    public boolean hideButtonNo() {
        return this.hasWizardLayout() && !this.hasPreviousContentPane();
    }

    public boolean hideButtonYesOK() {
        return false;
    }

    public String getButtonYesOKText() {
        return null;
    }

    public String getButtonNoText() {
        return null;
    }

    public String getButtonCancelText() {
        return null;
    }

    protected final JButton getButtonNo() {
        return this.m_btnNo;
    }

    public final void setDefaultButton(int a_defaultButton) {
        this.m_defaultButton = a_defaultButton < 0 || a_defaultButton > 5 ? 0 : a_defaultButton;
    }

    public final int getDefaultButton() {
        return this.m_defaultButton;
    }

    public final int getDefaultButtonOperation() {
        return this.m_defaultButtonOperation;
    }

    public final void setDefaultButtonOperation(int a_defaultButtonOperation) throws IllegalArgumentException {
        this.m_defaultButtonOperation = a_defaultButtonOperation;
    }

    public Object getValue() {
        return null;
    }

    public final int getButtonValue() {
        return this.m_value;
    }

    public final void setButtonValue(int a_value) {
        this.m_value = 2 == a_value || 0 == a_value || -1 == a_value || 0 == a_value || 1 == a_value ? a_value : Integer.MIN_VALUE;
    }

    public final boolean hasValidValue() {
        return this.getButtonValue() != 2 && this.getButtonValue() != -1 && this.getButtonValue() != Integer.MIN_VALUE;
    }

    public boolean isAutomaticFocusSettingEnabled() {
        return true;
    }

    public final boolean isActive() {
        return this.m_currentlyActiveContentPane != null && this.m_parentDialog.getContentPane() == this.m_currentlyActiveContentPane;
    }

    public final boolean isVisible() {
        return this.isActive() && this.isDialogVisible();
    }

    public String getText() {
        return this.m_strText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setText(String a_strText) {
        if (this.m_strText == null) {
            throw new IllegalStateException("This content pane does not contain a text field!");
        }
        RootPaneContainer rootPaneContainer = this.getDialog();
        synchronized (rootPaneContainer) {
            if (this.isVisible()) {
                this.m_lblText.setText(JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(a_strText));
                this.getDialog().notifyAll();
                return;
            }
            JAPDialog dialog = new JAPDialog((JAPDialog)null, "");
            RootPaneContainer ownerDialog = this.getDialog();
            boolean bWasActive = this.isActive();
            boolean bWasUnlimitedSize = false;
            boolean bCutFound = false;
            Dimension dialogSize = ownerDialog instanceof JDialog ? ((JDialog)ownerDialog).getSize() : ((JAPDialog)ownerDialog).getSize();
            if (dialogSize.width == 0 || dialogSize.height == 0) {
                throw new IllegalStateException("The parent dialog has a size <=0! This is not allowed when changing the text.");
            }
            dialog.setSize(dialogSize);
            if (this.m_lblText != null) {
                this.m_titlePane.remove(this.m_lblText);
            }
            this.m_strText = JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(a_strText);
            if (this.m_strText == null || this.m_strText.trim().length() == 0) {
                this.m_strText = "";
                return;
            }
            this.m_lblText = new JAPHtmlMultiLineLabel(this.m_strText, 0);
            this.m_lblText.setFontStyle(0);
            this.m_titlePane.add((Component)this.m_lblText, this.m_textConstraints);
            this.m_parentDialog = dialog;
            if (this.m_rootPane.getPreferredSize().equals(new Dimension(2500, 2500))) {
                bWasUnlimitedSize = true;
            }
            this.m_rootPane.setPreferredSize(null);
            if (this.m_lblSeeFullText != null) {
                this.m_titlePane.remove(this.m_lblSeeFullText);
                this.m_lblSeeFullText = null;
            }
            this.updateDialog(false);
            if (Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                return;
            }
            this.m_lblText.setText(this.m_strText);
            this.m_lblText.setPreferredWidth(this.getContentPane().getSize().width);
            GridBagConstraints contraints = (GridBagConstraints)this.m_textConstraints.clone();
            contraints.gridy = 2;
            contraints.insets = new Insets(0, 0, 0, 0);
            this.m_lblSeeFullText = new JAPHtmlMultiLineLabel();
            this.m_lblSeeFullText.setPreferredSize(new Dimension(this.getContentPane().getSize().width, 0));
            this.m_titlePane.add((Component)this.m_lblSeeFullText, contraints);
            this.updateDialog(false);
            this.m_titlePane.remove(this.m_lblSeeFullText);
            if (dialog.getContentPane().getSize().height < dialog.getContentPane().getPreferredSize().height) {
                int height = dialog.getSize().height;
                int width = dialog.getSize().width;
                dialog.pack();
                if ((double)dialog.getSize().height > (double)dialogSize.height * 1.2 || (double)dialog.getSize().width > (double)dialogSize.width * 1.2) {
                    dialog.setSize(width, height);
                } else if (ownerDialog instanceof JDialog) {
                    ((JDialog)ownerDialog).setSize(dialog.getSize());
                } else {
                    ((JAPDialog)ownerDialog).setSize(dialog.getSize());
                }
            }
            if (dialog.getContentPane().getSize().height < dialog.getContentPane().getPreferredSize().height) {
                this.m_lblSeeFullText = new JAPHtmlMultiLineLabel("<A href=''>(" + JAPMessages.getString(MSG_SEE_FULL_MESSAGE) + ")</A>", this.m_lblText.getFont(), 0);
                this.m_lblSeeFullText.setCursor(Cursor.getPredefinedCursor(12));
                this.m_lblSeeFullText.setPreferredSize(new Dimension(this.getContentPane().getSize().width, this.m_lblSeeFullText.getPreferredSize().height));
                this.m_lblSeeFullText.addMouseListener(new MouseAdapter(){

                    public void mouseClicked(MouseEvent a_event) {
                        if (DialogContentPane.this.m_layout.getTitle() != null) {
                            JAPDialog.showMessageDialog((Component)DialogContentPane.this.m_lblSeeFullText, DialogContentPane.this.m_strText, DialogContentPane.this.m_layout.getTitle());
                        } else {
                            JAPDialog.showMessageDialog(DialogContentPane.this.m_lblSeeFullText, DialogContentPane.this.m_strText);
                        }
                    }
                });
                this.m_titlePane.add((Component)this.m_lblSeeFullText, contraints);
                int totalLength = this.m_lblText.getHTMLDocumentLength();
                int currentCut = totalLength / 2;
                int bestCut = 0;
                for (int i = 0; i < 6; ++i) {
                    if (i == 5) {
                        if (bCutFound) {
                            currentCut = bestCut;
                        } else {
                            this.m_titlePane.remove(this.m_lblText);
                            this.m_lblText = null;
                            this.updateDialog(false);
                            break;
                        }
                    }
                    this.m_lblText.setText(this.m_strText);
                    this.m_lblText.cutHTMLDocument(currentCut);
                    this.m_lblText.setText(JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(this.m_lblText.getText()) + MORE_POINTS);
                    this.updateDialog(false);
                    if (dialog.getContentPane().getSize().height < dialog.getContentPane().getPreferredSize().height) {
                        if (bCutFound) {
                            currentCut = bestCut + bestCut / (i + 2);
                            continue;
                        }
                        currentCut /= 2;
                        continue;
                    }
                    bCutFound = true;
                    if (bestCut < currentCut) {
                        bestCut = currentCut;
                    }
                    currentCut += currentCut / 2;
                }
                if (bCutFound && bestCut >= totalLength) {
                    this.m_lblText.setText(this.m_strText);
                    this.m_titlePane.remove(this.m_lblSeeFullText);
                }
            }
            if (this.m_lblText != null) {
                this.m_lblText.setText("<font color=#000000>" + JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(this.m_lblText.getText()) + "</font>");
            }
            this.m_parentDialog = ownerDialog;
            if (bWasUnlimitedSize) {
                this.m_rootPane.setPreferredSize(new Dimension(2500, 2500));
            }
            if (bWasActive) {
                this.updateDialog(false);
            }
            this.getDialog().notifyAll();
        }
    }

    public RootPaneContainer getDialog() {
        return this.m_parentDialog;
    }

    private Container getDialogContentPane() {
        if (this.m_parentDialog instanceof JAPDialog) {
            return ((JAPDialog)this.m_parentDialog).getContentPane();
        }
        return ((JDialog)this.m_parentDialog).getContentPane();
    }

    public final boolean isDialogVisible() {
        return this.m_parentDialog instanceof JAPDialog && ((JAPDialog)this.m_parentDialog).isVisible() || this.m_parentDialog instanceof JDialog && ((JDialog)this.m_parentDialog).isVisible();
    }

    public void addDialogWindowListener(WindowListener a_listener) {
        if (this.m_parentDialog instanceof JDialog) {
            ((JDialog)this.m_parentDialog).addWindowListener(a_listener);
        } else {
            ((JAPDialog)this.m_parentDialog).addWindowListener(a_listener);
        }
    }

    public synchronized void addComponentListener(ComponentListener a_listener) {
        if (a_listener != null) {
            this.m_componentListeners.addElement(a_listener);
        }
    }

    public synchronized void removeComponentListener(ComponentListener a_listener) {
        this.m_componentListeners.removeElement(a_listener);
    }

    public void addDialogComponentListener(ComponentListener a_listener) {
        if (this.m_parentDialog instanceof JDialog) {
            ((JDialog)this.m_parentDialog).addComponentListener(a_listener);
        } else {
            ((JAPDialog)this.m_parentDialog).addComponentListener(a_listener);
        }
    }

    public void removeDialogComponentListener(ComponentListener a_listener) {
        if (this.m_parentDialog instanceof JDialog) {
            ((JDialog)this.m_parentDialog).removeComponentListener(a_listener);
        } else {
            ((JAPDialog)this.m_parentDialog).removeComponentListener(a_listener);
        }
    }

    public void removeDialogWindowListener(WindowListener a_listener) {
        if (this.m_parentDialog instanceof JDialog) {
            ((JDialog)this.m_parentDialog).removeWindowListener(a_listener);
        } else {
            ((JAPDialog)this.m_parentDialog).removeWindowListener(a_listener);
        }
    }

    public boolean isDisposed() {
        return this.m_bDisposed;
    }

    public synchronized void dispose() {
        this.m_bDisposed = true;
        if (this.m_tempDialog != null) {
            this.m_tempDialog.dispose();
        }
        if (this.m_titlePane != null) {
            this.m_titlePane.removeAll();
        }
        this.m_titlePane = null;
        if (this.m_rootPane != null) {
            this.m_rootPane.removeAll();
        }
        this.m_rootPane = null;
        if (this.m_contentPane != null) {
            this.m_contentPane.removeAll();
        }
        this.m_contentPane = null;
        if (this.m_panelOptions != null) {
            this.m_panelOptions.removeAll();
        }
        this.m_panelOptions = null;
        this.m_parentDialog = null;
        this.m_lblText = null;
        this.m_componentListeners.removeAllElements();
        if (this.m_btnCancel != null) {
            this.m_btnCancel.removeActionListener(this.m_buttonListener);
        }
        if (this.m_btnYesOK != null) {
            this.m_btnYesOK.removeActionListener(this.m_buttonListener);
        }
        if (this.m_btnNo != null) {
            this.m_btnNo.removeActionListener(this.m_buttonListener);
        }
        if (this.m_btnHelp != null) {
            this.m_btnHelp.removeActionListener(this.m_buttonListener);
        }
        this.m_buttonListener = null;
        if (this.m_currentlyActiveContentPane != null) {
            this.m_currentlyActiveContentPane.removeComponentListener(this.m_currentlyActiveContentPaneComponentListener);
        }
        this.m_currentlyActiveContentPaneComponentListener = null;
        this.m_currentlyActiveContentPane = null;
        this.m_nextContentPane = null;
        this.m_previousContentPane = null;
    }

    public final void closeDialog(boolean a_bDispose) {
        block10: {
            try {
                if (a_bDispose) {
                    if (this.m_parentDialog instanceof JDialog) {
                        ((JDialog)this.m_parentDialog).dispose();
                    } else {
                        try {
                            ((JAPDialog)this.m_parentDialog).dispose();
                        }
                        catch (IllegalMonitorStateException a_e) {
                            LogHolder.log(7, LogType.GUI, a_e);
                        }
                    }
                } else if (this.m_parentDialog instanceof JDialog) {
                    ((JDialog)this.m_parentDialog).setVisible(false);
                } else {
                    ((JAPDialog)this.m_parentDialog).setVisible(false);
                }
            }
            catch (NullPointerException a_e) {
                if (this.isDisposed()) break block10;
                throw a_e;
            }
        }
    }

    private JAPDialog getJAPDialog() {
        if (this.m_parentDialog instanceof JAPDialog) {
            return (JAPDialog)this.m_parentDialog;
        }
        return null;
    }

    private static Icon findMessageIcon(JOptionPane a_optionPane) {
        Icon icon = null;
        block0: for (int i = 0; i < a_optionPane.getComponentCount(); ++i) {
            if (!(a_optionPane.getComponent(i) instanceof Container)) continue;
            Container currentPanel = (Container)a_optionPane.getComponent(i);
            for (int j = 0; j < currentPanel.getComponentCount(); ++j) {
                if (!(currentPanel.getComponent(j) instanceof JLabel)) continue;
                icon = ((JLabel)currentPanel.getComponent(j)).getIcon();
                continue block0;
            }
        }
        return icon;
    }

    private final synchronized int printStatusMessageInternal(String a_strMessage, int a_messageType) {
        return this.printStatusMessageInternal(a_strMessage, a_messageType, null);
    }

    private final synchronized int printStatusMessageInternal(String a_strMessage, int a_messageType, final URL a_urlLinked) {
        String strHref;
        if (a_strMessage == null || a_strMessage.trim().length() == 0) {
            return 0;
        }
        String strMessage = JAPHtmlMultiLineLabel.removeTagsAndNewLines(a_strMessage);
        String strColor = 0 == a_messageType || 2 == a_messageType ? "red" : "black";
        JAPHtmlMultiLineLabel dummyLabel = new JAPHtmlMultiLineLabel(strMessage, this.m_lblMessage.getFont());
        if (dummyLabel.getPreferredSize().width > this.m_lblMessage.getSize().width) {
            String strMessageTitle = 0 == a_messageType ? JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR) : (2 == a_messageType ? JAPMessages.getString(JAPDialog.MSG_TITLE_WARNING) : JAPMessages.getString(JAPDialog.MSG_TITLE_INFO));
            this.clearStatusMessage();
            int bestSize = 0;
            int currentSize = strMessage.length() / 2;
            for (int i = 0; currentSize > 1 && (i < 6 || bestSize >= strMessage.length()); ++i) {
                dummyLabel.setText(strMessage.substring(0, currentSize) + MORE_POINTS);
                if (dummyLabel.getPreferredSize().width <= this.m_lblMessage.getSize().width) {
                    bestSize = Math.max(bestSize, currentSize) - 2;
                    currentSize += currentSize / (i + 2);
                    continue;
                }
                currentSize /= 2;
            }
            strMessage = bestSize <= 5 ? MORE_POINTS : strMessage.substring(0, bestSize) + MORE_POINTS;
            if (a_urlLinked == null) {
                strHref = " href=\"\"";
                this.m_lblMessage.setToolTipText(JAPMessages.getString(MSG_SEE_FULL_MESSAGE));
                this.m_linkedListener = new LinkedDialog(a_strMessage, strMessageTitle, -1, a_messageType);
                this.m_lblMessage.addMouseListener(this.m_linkedListener);
                this.m_lblMessage.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                strHref = "";
            }
        } else {
            this.clearStatusMessage();
            strHref = "";
        }
        if (a_urlLinked != null) {
            strHref = " href=\"\"";
            this.m_lblMessage.setToolTipText(JAPMessages.getString(MSG_OPEN_IN_BROWSER));
            this.m_linkedListener = new MouseAdapter(){

                public void mouseClicked(MouseEvent a_event) {
                    AbstractOS.getInstance().openURL(a_urlLinked);
                }
            };
            this.m_lblMessage.addMouseListener(this.m_linkedListener);
            this.m_lblMessage.setCursor(Cursor.getPredefinedCursor(12));
        }
        strMessage = "<A style=\"color:" + strColor + "\"" + strHref + "> " + strMessage + " </A>";
        this.m_lblMessage.setText(strMessage);
        ++this.m_idStatusMessage;
        return this.m_idStatusMessage;
    }

    private void setNextContentPane(DialogContentPane a_nextContentPane) {
        if (this.m_nextContentPane != null) {
            this.m_nextContentPane.m_previousContentPane = null;
        }
        this.m_nextContentPane = a_nextContentPane;
    }

    private DialogContentPane moveToContentPane(boolean a_bNext) {
        CheckError errors = null;
        DialogContentPane currentContentPane = this;
        if (a_bNext) {
            while ((currentContentPane = currentContentPane.getNextContentPane()) != null && currentContentPane.isSkippedAsNextContentPane()) {
            }
        } else {
            while ((currentContentPane = currentContentPane.getPreviousContentPane()) != null && currentContentPane.isSkippedAsPreviousContentPane()) {
            }
        }
        if (currentContentPane != null) {
            errors = currentContentPane.updateDialog();
            boolean bFocused = false;
            this.checkErrors(null, this.m_rememberedUpdateErrors);
            if (errors != null) {
                currentContentPane = a_bNext && this.isSkippedAsPreviousContentPane() || !a_bNext && this.isSkippedAsNextContentPane() ? this.moveToContentPane(!a_bNext) : this;
                currentContentPane.checkErrors(errors, this.m_rememberedUpdateErrors);
                return currentContentPane;
            }
            if (currentContentPane.isVisible()) {
                if (a_bNext) {
                    if (currentContentPane.m_btnYesOK != null && currentContentPane.m_btnYesOK.isEnabled()) {
                        if (currentContentPane.isAutomaticFocusSettingEnabled()) {
                            currentContentPane.m_btnYesOK.requestFocus();
                        }
                        this.getDialog().getRootPane().setDefaultButton(currentContentPane.m_btnYesOK);
                        bFocused = true;
                    }
                } else if (currentContentPane.m_btnYesOK != null && currentContentPane.m_btnYesOK.isEnabled()) {
                    if (currentContentPane.isAutomaticFocusSettingEnabled()) {
                        currentContentPane.m_btnYesOK.requestFocus();
                    }
                    this.getDialog().getRootPane().setDefaultButton(currentContentPane.m_btnYesOK);
                    bFocused = true;
                } else if (currentContentPane.m_btnNo != null && currentContentPane.m_btnNo.isEnabled()) {
                    if (currentContentPane.isAutomaticFocusSettingEnabled()) {
                        currentContentPane.getButtonNo().requestFocus();
                    }
                    this.getDialog().getRootPane().setDefaultButton(currentContentPane.getButtonNo());
                    bFocused = true;
                }
                if (!bFocused && currentContentPane.m_btnCancel != null && currentContentPane.m_btnCancel.isEnabled()) {
                    if (currentContentPane.isAutomaticFocusSettingEnabled()) {
                        currentContentPane.m_btnCancel.requestFocus();
                    }
                    this.getDialog().getRootPane().setDefaultButton(currentContentPane.m_btnCancel);
                }
            }
        } else {
            currentContentPane = this;
            JAPDialog dialog = this.getJAPDialog();
            if ((this.getDefaultButtonOperation() & 2) > 0) {
                this.closeDialog(true);
            } else if ((this.getDefaultButtonOperation() & 1) > 0) {
                this.closeDialog(false);
            } else if (dialog != null && dialog.getDefaultCloseOperation() == 2) {
                this.closeDialog(true);
            } else if (dialog != null && dialog.getDefaultCloseOperation() == 1) {
                this.closeDialog(true);
            }
        }
        return currentContentPane;
    }

    private boolean checkErrors(CheckError a_errors, Vector a_rememberedErrors) {
        for (int i = a_rememberedErrors.size() - 1; i >= 0; --i) {
            ((CheckError)a_rememberedErrors.elementAt(i)).undoErrorAction();
            a_rememberedErrors.removeElementAt(i);
        }
        if (a_errors != null) {
            if (a_errors.hasDisplayableErrorMessage()) {
                this.printErrorStatusMessage(a_errors.getMessage(), a_errors.getThrowable(), false);
            }
            a_rememberedErrors.addElement(a_errors);
            a_errors.doErrorAction();
            if (a_errors.hasDisplayableErrorMessage()) {
                this.printStatusMessage(JAPDialog.retrieveErrorMessage(a_errors.getMessage(), a_errors.getThrowable()), 0, a_errors.getURL());
            }
            return false;
        }
        return true;
    }

    private void createDefaultOptions() {
        this.m_panelOptions = new JPanel();
        if (this.m_btnCancel == null) {
            this.m_btnCancel = new JButton();
            this.m_btnCancel.addActionListener(this.m_buttonListener);
        }
        this.m_btnCancel.setText(JAPMessages.getString(MSG_CANCEL));
        String text = this.getButtonCancelText();
        if (text != null) {
            this.m_btnCancel.setText(text);
        }
        this.m_panelOptions.add(this.m_btnCancel);
        this.m_btnCancel.setVisible(false);
        if (!(this.hideButtonCancel() || 1 != this.m_options.getOptionType() && 2 != this.m_options.getOptionType() && -2147483647 != this.m_options.getOptionType())) {
            this.m_btnCancel.setVisible(true);
        }
        if (this.m_btnNo == null) {
            this.m_btnNo = new JButton();
            this.m_btnNo.addActionListener(this.m_buttonListener);
        }
        this.m_btnNo.setText(JAPMessages.getString(MSG_NO));
        text = this.getButtonNoText();
        if (text != null) {
            this.m_btnNo.setText(text);
        }
        this.m_panelOptions.add(this.m_btnNo);
        this.m_btnNo.setVisible(false);
        if (0 == this.m_options.getOptionType() || 1 == this.m_options.getOptionType()) {
            if (!this.hideButtonNo()) {
                this.m_btnNo.setVisible(true);
            }
            if (this.m_btnYesOK == null) {
                this.m_btnYesOK = new JButton();
                this.m_btnYesOK.addActionListener(this.m_buttonListener);
            }
            this.m_btnYesOK.setText(JAPMessages.getString(MSG_YES));
            text = this.getButtonYesOKText();
            if (text != null) {
                this.m_btnYesOK.setText(text);
            }
            this.m_panelOptions.add(this.m_btnYesOK);
        } else if (2 == this.m_options.getOptionType() || -1 == this.m_options.getOptionType()) {
            if (this.m_btnYesOK == null) {
                this.m_btnYesOK = new JButton();
                this.m_btnYesOK.addActionListener(this.m_buttonListener);
            }
            this.m_btnYesOK.setText(JAPMessages.getString(MSG_OK));
            text = this.getButtonYesOKText();
            if (text != null) {
                this.m_btnYesOK.setText(text);
            }
            this.m_panelOptions.add(this.m_btnYesOK);
        }
        if (this.m_btnYesOK != null & this.hideButtonYesOK()) {
            this.m_btnYesOK.setVisible(false);
        }
        this.addHelpButton();
    }

    private JButton addHelpButton() {
        if (this.getHelpContext() != null) {
            if (this.m_btnHelp == null) {
                if (this.m_helpContext instanceof JAPHelpContext.IURLHelpContext) {
                    this.m_btnHelp = new JButton(((JAPHelpContext.IURLHelpContext)this.m_helpContext).getURLMessage());
                    this.m_btnHelp.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent a_event) {
                            AbstractOS.getInstance().openURL(((JAPHelpContext.IURLHelpContext)DialogContentPane.this.m_helpContext).getHelpURL());
                        }
                    });
                } else {
                    this.m_btnHelp = JAPHelp.createHelpButton(this);
                }
            }
            this.m_panelOptions.add(this.m_btnHelp);
        }
        return this.m_btnHelp;
    }

    private void createWizardOptions() {
        this.m_panelOptions = Box.createHorizontalBox();
        if (this.addHelpButton() != null) {
            this.m_panelOptions.add(Box.createHorizontalStrut(5));
        }
        if (this.m_btnNo == null) {
            this.m_btnNo = new JButton();
            this.m_btnNo.addActionListener(this.m_buttonListener);
        }
        this.m_btnNo.setText("< " + JAPMessages.getString(MSG_PREVIOUS));
        String text = this.getButtonNoText();
        if (text != null) {
            this.m_btnNo.setText(text);
        }
        this.m_panelOptions.add(this.m_btnNo);
        this.m_btnNo.setEnabled(!this.hideButtonNo());
        this.m_btnNo.setVisible(!(this instanceof WorkerContentPane));
        if (this.m_btnYesOK == null) {
            this.m_btnYesOK = new JButton();
            this.m_btnYesOK.addActionListener(this.m_buttonListener);
        }
        this.setTextOfWizardNextButton();
        this.m_panelOptions.add(this.m_btnYesOK);
        this.m_btnYesOK.setEnabled(!this.hideButtonYesOK());
        this.m_btnYesOK.setVisible(!(this instanceof WorkerContentPane));
        this.m_panelOptions.add(Box.createHorizontalStrut(5));
        if (this.m_btnCancel == null) {
            this.m_btnCancel = new JButton();
            this.m_btnCancel.addActionListener(this.m_buttonListener);
        }
        this.m_btnCancel.setText(JAPMessages.getString(MSG_CANCEL));
        text = this.getButtonCancelText();
        if (text != null) {
            this.m_btnCancel.setText(text);
        }
        this.m_panelOptions.add(this.m_btnCancel);
        this.m_btnCancel.setEnabled(!this.hideButtonCancel());
        this.m_btnCancel.setVisible(true);
    }

    private void setTextOfWizardNextButton() {
        String text = this.getButtonYesOKText();
        if (text != null) {
            this.m_btnYesOK.setText(text);
        } else if (this.hasNextContentPane() || this.hasPreviousContentPane() && (this.getDefaultButtonOperation() & 0x80) > 0) {
            this.m_btnYesOK.setText(JAPMessages.getString(MSG_NEXT) + " >");
        } else {
            this.m_btnYesOK.setText(JAPMessages.getString(MSG_FINISH));
        }
        this.m_btnYesOK.invalidate();
    }

    public void setMouseListener(MouseListener a_listener) {
        if (this.m_strText == null) {
            throw new IllegalStateException("This content pane does not contain a text field!");
        }
        this.m_lblText.addMouseListener(a_listener);
        this.m_lblSeeFullText.addMouseListener(a_listener);
    }

    private void createOptions() {
        boolean bHasWizardLayout = this.hasWizardLayout();
        if (this.m_buttonListener == null) {
            this.m_buttonListener = new ButtonListener();
        }
        if (bHasWizardLayout) {
            this.createWizardOptions();
        } else {
            this.createDefaultOptions();
        }
    }

    private boolean isSomethingDoneOnClick(CheckError a_errors, int a_opNext, int a_opPrevious, int a_opHide, int a_opDispose, int a_opWindowClosingEvent) {
        boolean bDoSomething;
        boolean bl = bDoSomething = a_errors == null && (this.getDefaultButtonOperation() & (0x47 | a_opNext | a_opPrevious | a_opHide | a_opDispose)) > 0;
        if (a_errors == null && !bDoSomething && this.getJAPDialog() != null) {
            bDoSomething = (this.getDefaultButtonOperation() & (0x80000 | a_opWindowClosingEvent)) > 0;
        }
        return bDoSomething;
    }

    private CheckError doDefaultButtonOperation(CheckError a_errors, int a_opNext, int a_opPrevious, int a_opHide, int a_opDispose, int a_opWindowClosingEvent) {
        if (!this.checkErrors(a_errors, this.m_rememberedErrors)) {
            return a_errors;
        }
        if (this.m_nextContentPane != null && (this.getDefaultButtonOperation() & a_opNext) > 0 && this.m_nextContentPane.isMoveForwardAllowed()) {
            this.moveToContentPane(true);
            return null;
        }
        if (this.m_previousContentPane != null && (this.getDefaultButtonOperation() & a_opPrevious) > 0 && this.m_previousContentPane.isMoveBackAllowed()) {
            this.moveToContentPane(false);
            return null;
        }
        if ((this.getDefaultButtonOperation() & a_opDispose) > 0) {
            this.closeDialog(true);
            return null;
        }
        if ((this.getDefaultButtonOperation() & a_opHide) > 0) {
            this.closeDialog(false);
            return null;
        }
        if (this.getJAPDialog() != null && (this.getDefaultButtonOperation() & a_opWindowClosingEvent) > 0) {
            this.getJAPDialog().doWindowClosing();
            return null;
        }
        return new CheckError(){

            public void doErrorAction() {
                DialogContentPane.this.doDefaultButtonOperation(null, 4, 64, 1, 2, 524288);
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (!JAPDialog.isConsoleOnly()) {
            for (int i = 0; i < MESSAGE_TYPES.length; ++i) {
                JOptionPane pane = new JOptionPane("", MESSAGE_TYPES[i]);
                pane.createDialog(null, "");
                DialogContentPane.MESSAGE_ICONS[i] = DialogContentPane.findMessageIcon(pane);
            }
        }
        MSG_OK = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_OK";
        MSG_YES = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_yes";
        MSG_NO = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_no";
        MSG_NEXT = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_next";
        MSG_PREVIOUS = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_previous";
        MSG_FINISH = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_finish";
        MSG_CANCEL = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_cancel";
        MSG_IGNORE = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + ".ignore";
        MSG_CONTINUE = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_continue";
        MSG_OPERATION_FAILED = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_operationFailed";
        MSG_SEE_FULL_MESSAGE = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + "_seeFullMessage";
        MSG_OPEN_IN_BROWSER = (class$gui$dialog$DialogContentPane == null ? (class$gui$dialog$DialogContentPane = DialogContentPane.class$("gui.dialog.DialogContentPane")) : class$gui$dialog$DialogContentPane).getName() + ".openInBrowser";
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent a_event) {
            CheckError operationErrors;
            CheckError errors;
            if (a_event == null || a_event.getSource() == null) {
                return;
            }
            if (a_event.getSource() == DialogContentPane.this.m_btnCancel) {
                errors = DialogContentPane.this.checkCancel();
                if (DialogContentPane.this.isSomethingDoneOnClick(errors, 32, 512, 4096, 32768, 65536)) {
                    DialogContentPane.this.setButtonValue(2);
                }
                operationErrors = DialogContentPane.this.doDefaultButtonOperation(errors, 32, 512, 4096, 32768, 65536);
            } else if (a_event.getSource() == DialogContentPane.this.m_btnYesOK) {
                errors = DialogContentPane.this.checkYesOK();
                if (DialogContentPane.this.isSomethingDoneOnClick(errors, 8, 128, 1024, 8192, 131072)) {
                    if (0 == DialogContentPane.this.m_options.getOptionType() || 1 == DialogContentPane.this.m_options.getOptionType()) {
                        DialogContentPane.this.setButtonValue(0);
                    } else {
                        DialogContentPane.this.setButtonValue(0);
                    }
                }
                operationErrors = DialogContentPane.this.doDefaultButtonOperation(errors, 8, 128, 1024, 8192, 131072);
            } else {
                errors = DialogContentPane.this.checkNo();
                if (DialogContentPane.this.isSomethingDoneOnClick(errors, 16, 256, 2048, 16384, 262144)) {
                    DialogContentPane.this.setButtonValue(1);
                }
                operationErrors = DialogContentPane.this.doDefaultButtonOperation(errors, 16, 256, 2048, 16384, 262144);
            }
            if (operationErrors != null && errors == null) {
                DialogContentPane.this.checkErrors(operationErrors, DialogContentPane.this.m_rememberedErrors);
            }
        }
    }

    private class ContentPaneComponentListener
    extends ComponentAdapter {
        private ContentPaneComponentListener() {
        }

        public void componentHidden(ComponentEvent a_event) {
            Vector listeners = (Vector)DialogContentPane.this.m_componentListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((ComponentListener)listeners.elementAt(i)).componentHidden(a_event);
            }
        }

        public void componentShown(ComponentEvent a_event) {
            if (DialogContentPane.this.isVisible()) {
                if (DialogContentPane.this.m_lblText != null) {
                    DialogContentPane.this.m_titlePane.remove(DialogContentPane.this.m_lblText);
                    DialogContentPane.this.m_lblText = new JAPHtmlMultiLineLabel(DialogContentPane.this.m_lblText.getText(), DialogContentPane.this.m_lblText.getFont(), 0);
                    DialogContentPane.this.m_titlePane.add((Component)DialogContentPane.this.m_lblText, DialogContentPane.this.m_textConstraints);
                    DialogContentPane.this.m_titlePane.revalidate();
                }
                Vector listeners = (Vector)DialogContentPane.this.m_componentListeners.clone();
                for (int i = 0; i < listeners.size(); ++i) {
                    ((ComponentListener)listeners.elementAt(i)).componentShown(a_event);
                }
            }
        }

        public void componentResized(ComponentEvent a_event) {
            Vector listeners = (Vector)DialogContentPane.this.m_componentListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((ComponentListener)listeners.elementAt(i)).componentResized(a_event);
            }
        }

        public void componentMoved(ComponentEvent a_event) {
            Vector listeners = (Vector)DialogContentPane.this.m_componentListeners.clone();
            for (int i = 0; i < listeners.size(); ++i) {
                ((ComponentListener)listeners.elementAt(i)).componentMoved(a_event);
            }
        }
    }

    private class DialogComponentListener
    extends ComponentAdapter {
        private DialogComponentListener() {
        }

        public void componentHidden(ComponentEvent a_event) {
            ComponentListener listener;
            if (DialogContentPane.this.getButtonValue() == Integer.MIN_VALUE) {
                DialogContentPane.this.setButtonValue(-1);
            }
            if ((listener = DialogContentPane.this.m_currentlyActiveContentPaneComponentListener) != null) {
                listener.componentHidden(new ComponentEvent(DialogContentPane.this.m_currentlyActiveContentPane, 103));
            }
        }

        public void componentShown(ComponentEvent a_event) {
        }
    }

    private class DialogWindowListener
    extends WindowAdapter {
        private DialogWindowListener() {
        }

        public void windowClosed(WindowEvent a_event) {
            ComponentListener listener;
            if (DialogContentPane.this.getButtonValue() == Integer.MIN_VALUE) {
                DialogContentPane.this.setButtonValue(-1);
            }
            if ((listener = DialogContentPane.this.m_currentlyActiveContentPaneComponentListener) != null) {
                listener.componentHidden(new ComponentEvent(DialogContentPane.this.m_currentlyActiveContentPane, 103));
            }
            if (!DialogContentPane.this.isDisposed()) {
                DialogContentPane.this.dispose();
            }
        }

        public void windowOpened(WindowEvent a_event) {
            ComponentListener listener;
            if (DialogContentPane.this.isVisible() && DialogContentPane.this.hasWizardLayout() && DialogContentPane.this.m_btnYesOK != null && DialogContentPane.this.m_btnYesOK.isEnabled()) {
                if (DialogContentPane.this.isAutomaticFocusSettingEnabled()) {
                    DialogContentPane.this.m_btnYesOK.requestFocus();
                }
                DialogContentPane.this.getDialog().getRootPane().setDefaultButton(DialogContentPane.this.m_btnYesOK);
            }
            if (DialogContentPane.this.getDialog() instanceof JDialog && (listener = DialogContentPane.this.m_currentlyActiveContentPaneComponentListener) != null) {
                listener.componentShown(new ComponentEvent(DialogContentPane.this.m_currentlyActiveContentPane, 102));
            }
        }
    }

    private class LinkedDialog
    extends MouseAdapter {
        private String m_strMessage;
        private String m_strTitle;
        private int m_optionType;
        private int m_messageType;

        public LinkedDialog(String a_strMessage, String a_strTitle, int a_optionType, int a_messageType) {
            this.m_strMessage = a_strMessage;
            this.m_strTitle = a_strTitle;
            this.m_optionType = a_optionType;
            this.m_messageType = a_messageType;
        }

        public void mouseClicked(MouseEvent a_event) {
            JAPDialog.showConfirmDialog((Component)DialogContentPane.this.m_lblMessage, this.m_strMessage, this.m_strTitle, this.m_optionType, this.m_messageType);
        }
    }

    public static class Layout {
        private String m_strTitle;
        private int m_messageType;
        private Icon m_icon;
        private boolean m_bCentered;

        public Layout() {
            this("", -1, null);
        }

        public Layout(int a_messageType) {
            this("", a_messageType, null);
        }

        public Layout(String a_strTitle) {
            this(a_strTitle, -1, null);
        }

        public Layout(Icon a_icon) {
            this("", -1, a_icon);
        }

        public Layout(int a_messageType, Icon a_icon) {
            this("", a_messageType, a_icon);
        }

        public Layout(String a_strTitle, int a_messageType) {
            this(a_strTitle, a_messageType, null);
        }

        public Layout(String a_strTitle, Icon a_icon) {
            this(a_strTitle, -1, a_icon);
        }

        public Layout(String a_strTitle, int a_messageType, Icon a_icon) {
            this.m_strTitle = a_strTitle;
            this.m_messageType = a_messageType;
            this.m_icon = a_icon;
            this.m_bCentered = true;
        }

        public boolean isCentered() {
            return this.m_bCentered;
        }

        public final String getTitle() {
            return this.m_strTitle;
        }

        public final int getMessageType() {
            return this.m_messageType;
        }

        public final Icon getIcon() {
            return this.m_icon;
        }
    }

    public static class CheckError {
        private String m_strMessage;
        private Throwable m_throwable;
        private URL m_url;

        public CheckError() {
            this("", null, null);
        }

        public CheckError(String a_strMessage) {
            this(a_strMessage, null, null);
        }

        public CheckError(String a_strMessage, URL a_url) {
            this(a_strMessage, null, a_url);
        }

        public CheckError(String a_strMessage, Throwable a_throwable) {
            this.m_strMessage = a_strMessage;
            this.m_throwable = a_throwable;
        }

        public CheckError(String a_strMessage, Throwable a_throwable, URL a_url) {
            this.m_strMessage = a_strMessage;
            this.m_throwable = a_throwable;
            this.m_url = a_url;
        }

        public URL getURL() {
            return this.m_url;
        }

        public void doErrorAction() {
        }

        public void undoErrorAction() {
        }

        public final Throwable getThrowable() {
            return this.m_throwable;
        }

        public final String getMessage() {
            return this.m_strMessage;
        }

        public final boolean hasDisplayableErrorMessage() {
            return JAPDialog.retrieveErrorMessage(this.m_strMessage, this.m_throwable) != null;
        }
    }

    public static interface IWizardSuitable {
    }
}

