/*
 * Decompiled with CFR 0.152.
 */
package jarify;

import jarify.JarFileEntry;
import jarify.JarManifest;
import jarify.JarSignatureFile;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

final class JarFile {
    private String m_FileName;
    private ZipFile m_ZipFile;
    private JarManifest m_Manifest;

    public JarFile(File file) throws ZipException, IOException, SecurityException {
        this.m_ZipFile = new ZipFile(file);
        this.m_FileName = this.m_ZipFile.getName();
        this.init();
    }

    private void init() throws IOException {
        ZipEntry mf = this.m_ZipFile.getEntry("META-INF/MANIFEST.MF");
        if (mf != null) {
            this.m_Manifest = new JarManifest(mf.getSize(), this.m_ZipFile.getInputStream(mf));
        }
    }

    public JarManifest getManifest() {
        return this.m_Manifest;
    }

    public boolean fileExists(String name) {
        return this.m_ZipFile.getEntry(name) != null;
    }

    public JarSignatureFile getSignatureFile(String alias) {
        ZipEntry sigFile = this.m_ZipFile.getEntry("META-INF/" + alias + ".SF");
        try {
            if (sigFile != null) {
                return new JarSignatureFile(sigFile.getName(), sigFile.getSize(), this.m_ZipFile.getInputStream(sigFile));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public JarFileEntry getSignatureBlockFile(String alias) {
        Enumeration<? extends ZipEntry> files = this.m_ZipFile.entries();
        alias = alias.toUpperCase();
        while (files.hasMoreElements()) {
            ZipEntry fileEntry = files.nextElement();
            try {
                if (!fileEntry.getName().startsWith("META-INF/" + alias) || !fileEntry.getName().toUpperCase().endsWith(alias + ".DSA") && !fileEntry.getName().toUpperCase().endsWith(alias + ".RSA")) continue;
                return new JarFileEntry(fileEntry.getName(), fileEntry.getSize(), this.m_ZipFile.getInputStream(fileEntry));
            }
            catch (IOException ex) {
            }
        }
        return null;
    }

    public Vector getSignatureBlockFiles(String alias) {
        Vector<JarFileEntry> sigBlockFiles = new Vector<JarFileEntry>();
        Enumeration<? extends ZipEntry> files = this.m_ZipFile.entries();
        while (files.hasMoreElements()) {
            ZipEntry fileEntry = files.nextElement();
            try {
                if (!fileEntry.getName().startsWith("META-INF/" + alias) || fileEntry.getName().toLowerCase().endsWith(".sf")) continue;
                sigBlockFiles.addElement(new JarFileEntry(fileEntry.getName(), fileEntry.getSize(), this.m_ZipFile.getInputStream(fileEntry)));
            }
            catch (IOException ex) {}
        }
        return sigBlockFiles;
    }

    public JarFileEntry getFileByName(String name) {
        ZipEntry file = null;
        try {
            file = this.m_ZipFile.getEntry(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        URL url = null;
        if (file == null) {
            try {
                url = new URL(name);
            }
            catch (MalformedURLException e) {
                return null;
            }
            catch (Exception e) {
                return null;
            }
            try {
                return new JarFileEntry(url.getFile(), url.openConnection().getContentLength(), url.openStream());
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            if (file != null) {
                return new JarFileEntry(file.getName(), file.getSize(), this.m_ZipFile.getInputStream(file));
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return this.m_FileName;
    }

    public Vector getAliasList() {
        Vector<String> alias = new Vector<String>();
        Enumeration<? extends ZipEntry> files = this.m_ZipFile.entries();
        while (files.hasMoreElements()) {
            ZipEntry file = files.nextElement();
            String name = file.getName().replace('\\', '/');
            int pos = file.getName().lastIndexOf("/");
            if (pos == -1 || !name.substring(0, pos).equals("META-INF") || !name.toLowerCase().endsWith(".sf")) continue;
            alias.addElement(name.substring(pos + 1, name.length() - 3));
        }
        return alias;
    }

    public boolean close() {
        try {
            this.m_ZipFile.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

