/*
 * Decompiled with CFR 0.152.
 */
package jondobrowsercommunicator;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.Socket;
import jondobrowsercommunicator.SocketServer;
import logging.LogHolder;
import logging.LogType;

public class SocketServerThread
extends Thread {
    Socket socket;
    InputStream inputstream;
    OutputStream outputstream;
    BufferedReader reader;
    PrintWriter writer;
    int MAX_SWITCHCASCADE_TRIAL = 5;
    long MAX_SECUREKEY_WAITING_TIME = 5000L;
    boolean isValidConnection = false;
    boolean pushHelpUrlPending = false;
    String helpUrl;

    public SocketServerThread(Socket socket) {
        this.socket = socket;
    }

    public synchronized void run() {
        try {
            this.inputstream = this.socket.getInputStream();
            this.outputstream = this.socket.getOutputStream();
            this.reader = new BufferedReader(new InputStreamReader(this.inputstream));
            this.writer = new PrintWriter(this.outputstream, true);
            long socketStartTimestamp = System.currentTimeMillis();
            while (true) {
                block15: {
                    try {
                        String data = this.readSocket();
                        if (this.isValidConnection) {
                            if (data.length() <= 0) break block15;
                            if (!data.endsWith(SocketServer.secureKey)) {
                                LogHolder.log(4, LogType.MISC, "Cannot authenticate the client. Closing connection.");
                                this.closeConnection();
                                break;
                            }
                            if (data.startsWith("switch-cascade")) {
                                LogHolder.log(6, LogType.MISC, "switch-cascade received.");
                                this.switchJondoCascade();
                            } else if (data.startsWith("ping")) {
                                LogHolder.log(6, LogType.MISC, "ping received.");
                                this.writeSocket("pong");
                            } else if (data.startsWith("save-config")) {
                                LogHolder.log(6, LogType.MISC, "save-config received.");
                                this.saveConfigFile();
                            }
                            if (!this.pushHelpUrlPending) break block15;
                            this.writeSocket("open-new-tab," + this.helpUrl);
                            LogHolder.log(6, LogType.MISC, "open-new-tab sent.");
                            this.pushHelpUrlPending = false;
                            break block15;
                        }
                        if (data.startsWith("get-token")) {
                            this.isValidConnection = true;
                            this.writeSocket("token," + SocketServer.secureKey);
                            SocketServer.socketConn = this;
                        } else if (System.currentTimeMillis() - socketStartTimestamp > this.MAX_SECUREKEY_WAITING_TIME) {
                            LogHolder.log(4, LogType.MISC, "Cannot authenticate the client. Closing connection.");
                            this.closeConnection();
                        }
                        break block15;
                    }
                    catch (Exception sockEx) {
                        LogHolder.log(4, LogType.MISC, "Socket communication unknown error.\r\n" + sockEx.toString());
                        this.closeConnection();
                    }
                    break;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception generalEx) {
            LogHolder.log(4, LogType.MISC, "Socket communication unknown error.\r\n" + generalEx.toString());
        }
    }

    public synchronized void closeConnection() {
        try {
            this.inputstream.close();
            this.outputstream.close();
            this.socket.close();
        }
        catch (Exception ioEx) {
            ioEx.printStackTrace();
        }
        this.isValidConnection = false;
    }

    public synchronized String readSocket() throws Exception {
        String data = "";
        while (this.reader.ready()) {
            int bufferLength = 256;
            char[] readBuffer = new char[bufferLength];
            int bytesRead = this.reader.read(readBuffer, 0, bufferLength);
            if (bytesRead > 0) {
                data = data + String.valueOf(readBuffer, 0, bytesRead);
            }
            if (bytesRead >= bufferLength) continue;
            break;
        }
        if (data.length() > 0 && data.substring(data.length() - 1).equals("\n")) {
            data = data.substring(0, data.length() - 1);
        }
        if (data.length() > 0 && data.substring(data.length() - 1).equals("\r")) {
            data = data.substring(0, data.length() - 1);
        }
        return data;
    }

    public synchronized void writeSocket(String data) {
        this.writer.print(data);
        this.writer.print("\r\n");
        this.writer.flush();
    }

    public synchronized boolean switchJondoCascade() {
        try {
            Object switchToNextMixCascadeResult;
            Class<?> japControllerClass = Class.forName("jap.JAPController");
            Method getInstanceMethod = japControllerClass.getMethod("getInstance", null);
            Method switchToNextMixCascadeMethod = japControllerClass.getMethod("switchToNextMixCascade", null);
            Method getCurrentMixCascadeMethod = japControllerClass.getMethod("getCurrentMixCascade", null);
            Object japControllerInstance = getInstanceMethod.invoke(null, null);
            Object getCurrentMixCascadeResult = getCurrentMixCascadeMethod.invoke(japControllerInstance, null);
            LogHolder.log(6, LogType.MISC, "Invoking jap.JAPController class methods to switch cascade until it is really changed for at most 5 times");
            for (int i = 0; i < this.MAX_SWITCHCASCADE_TRIAL && getCurrentMixCascadeResult == (switchToNextMixCascadeResult = switchToNextMixCascadeMethod.invoke(japControllerInstance, null)); ++i) {
            }
            return true;
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.MISC, "switchJondoCascade() failed.\r\n" + e.toString());
            return false;
        }
    }

    public synchronized boolean saveConfigFile() {
        try {
            Class<?> japControllerClass = Class.forName("jap.JAPController");
            Method getInstanceMethod = japControllerClass.getMethod("getInstance", null);
            Method saveConfigFileMethod = japControllerClass.getMethod("saveConfigFile", null);
            Object japControllerInstance = getInstanceMethod.invoke(null, null);
            Object saveConfigFileResult = saveConfigFileMethod.invoke(japControllerInstance, null);
            return true;
        }
        catch (Exception e) {
            LogHolder.log(4, LogType.MISC, "saveConfigFile() failed.\r\n" + e.toString());
            return false;
        }
    }

    public void setPushHelpUrlPending(String url) {
        this.pushHelpUrlPending = true;
        this.helpUrl = url;
    }
}

