/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class FTPListParseEngine {
    private Vector entries = new Vector();
    private int _internalIterator;
    FTPFileEntryParser parser = null;

    public FTPListParseEngine(FTPFileEntryParser parser) {
        this.parser = parser;
    }

    public void readServerList(InputStream stream, String encoding) throws IOException {
        this.entries = new Vector();
        this.readStream(stream, encoding);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    public void readServerList(InputStream stream) throws IOException {
        this.readServerList(stream, null);
    }

    private void readStream(InputStream stream, String encoding) throws IOException {
        BufferedReader reader = encoding == null ? new BufferedReader(new InputStreamReader(stream)) : new BufferedReader(new InputStreamReader(stream, encoding));
        String line = this.parser.readNextEntry(reader);
        while (line != null) {
            this.entries.addElement(line);
            line = this.parser.readNextEntry(reader);
        }
        reader.close();
    }

    public FTPFile[] getNext(int quantityRequested) {
        Vector<FTPFile> tmpResults = new Vector<FTPFile>();
        for (int count = quantityRequested; count > 0 && this.hasNext(); --count) {
            String entry = (String)this.entries.elementAt(++this._internalIterator);
            FTPFile temp = this.parser.parseFTPEntry(entry);
            tmpResults.addElement(temp);
        }
        Object[] result = new FTPFile[tmpResults.size()];
        tmpResults.copyInto(result);
        return result;
    }

    public FTPFile[] getPrevious(int quantityRequested) {
        Vector<FTPFile> tmpResults = new Vector<FTPFile>();
        for (int count = quantityRequested; count > 0 && this.hasPrevious(); --count) {
            String entry = (String)this.entries.elementAt(--this._internalIterator);
            FTPFile temp = this.parser.parseFTPEntry(entry);
            tmpResults.insertElementAt(temp, 0);
        }
        Object[] result = new FTPFile[tmpResults.size()];
        tmpResults.copyInto(result);
        return result;
    }

    public FTPFile[] getFiles() throws IOException {
        Vector<FTPFile> tmpResults = new Vector<FTPFile>();
        Enumeration iter = this.entries.elements();
        while (iter.hasMoreElements()) {
            String entry = (String)iter.nextElement();
            FTPFile temp = this.parser.parseFTPEntry(entry);
            tmpResults.addElement(temp);
        }
        FTPFile[] result = new FTPFile[tmpResults.size()];
        iter = tmpResults.elements();
        int i = 0;
        while (iter.hasMoreElements()) {
            result[i++] = (FTPFile)iter.nextElement();
        }
        return result;
    }

    public boolean hasNext() {
        return this._internalIterator < this.entries.size() - 1;
    }

    public boolean hasPrevious() {
        return this._internalIterator > 0;
    }

    public void resetIterator() {
        this._internalIterator = 0;
    }
}

