/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.ModuleException;
import HTTPClient.Response;
import HTTPClient.ResponseHandler;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class RespInputStream
extends InputStream
implements GlobalConstants {
    private StreamDemultiplexor demux = null;
    private ResponseHandler resph;
    boolean closed = false;
    private boolean dont_truncate = false;
    private byte[] buffer = null;
    private boolean interrupted = false;
    private int offset = 0;
    private int end = 0;
    int count = 0;
    private byte[] ch = new byte[1];

    RespInputStream(StreamDemultiplexor demux, ResponseHandler resph) {
        this.demux = demux;
        this.resph = resph;
    }

    public synchronized int read() throws IOException {
        int rcvd = this.read(this.ch, 0, 1);
        if (rcvd == 1) {
            return this.ch[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int rcvd;
        if (this.closed) {
            return -1;
        }
        int left = this.end - this.offset;
        if (!(this.buffer == null || left == 0 && this.interrupted)) {
            if (left == 0) {
                return -1;
            }
            len = len > left ? left : len;
            System.arraycopy(this.buffer, this.offset, b, off, len);
            this.offset += len;
            return len;
        }
        if (GlobalConstants.DebugDemux) {
            Util.logLine("RspIS: Reading stream " + this.hashCode());
        }
        if ((rcvd = this.demux.read(b, off, len, this.resph, this.resph.resp.timeout)) != -1 && this.resph.resp.got_headers) {
            this.count += rcvd;
        }
        return rcvd;
    }

    public synchronized long skip(long num) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int left = this.end - this.offset;
        if (!(this.buffer == null || left == 0 && this.interrupted)) {
            num = num > (long)left ? (long)left : num;
            this.offset = (int)((long)this.offset + num);
            return num;
        }
        long skpd = this.demux.skip(num, this.resph);
        if (this.resph.resp.got_headers) {
            this.count = (int)((long)this.count + skpd);
        }
        return skpd;
    }

    public synchronized int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        if (!(this.buffer == null || this.end - this.offset == 0 && this.interrupted)) {
            return this.end - this.offset;
        }
        return this.demux.available(this.resph);
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.dont_truncate && (this.buffer == null || this.interrupted)) {
                this.readAll(this.resph.resp.timeout);
            }
            if (GlobalConstants.DebugDemux) {
                Util.logLine("Demux: User closed stream " + this.hashCode());
            }
            this.demux.closeSocketIfAllStreamsClosed();
            if (this.dont_truncate) {
                try {
                    this.resph.resp.http_resp.invokeTrailerHandlers(false);
                }
                catch (ModuleException me) {
                    throw new IOException(me.toString());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    void readAll(int timeout) throws IOException {
        if (GlobalConstants.DebugDemux) {
            Util.logLine("RspIS: Read-all on stream " + this.hashCode());
        }
        Response response = this.resph.resp;
        synchronized (response) {
            if (!this.resph.resp.got_headers) {
                int sav_to = this.resph.resp.timeout;
                this.resph.resp.timeout = timeout;
                this.resph.resp.getStatusCode();
                this.resph.resp.timeout = sav_to;
            }
        }
        RespInputStream respInputStream = this;
        synchronized (respInputStream) {
            if (this.buffer != null && !this.interrupted) {
                return;
            }
            int rcvd = 0;
            try {
                if (this.closed) {
                    this.buffer = new byte[10000];
                    do {
                        this.count += rcvd;
                    } while ((rcvd = this.demux.read(this.buffer, 0, this.buffer.length, this.resph, timeout)) != -1);
                    this.buffer = null;
                } else {
                    if (this.buffer == null) {
                        this.buffer = new byte[10000];
                        this.offset = 0;
                        this.end = 0;
                    }
                    while ((rcvd = this.demux.read(this.buffer, this.end, this.buffer.length - this.end, this.resph, timeout)) >= 0) {
                        this.count += rcvd;
                        this.end += rcvd;
                        this.buffer = Util.resizeArray(this.buffer, this.end + 10000);
                    }
                }
            }
            catch (InterruptedIOException iioe) {
                this.interrupted = true;
                throw iioe;
            }
            catch (IOException ioe) {
                this.buffer = null;
            }
            this.interrupted = false;
        }
    }

    synchronized void dontTruncate() {
        this.dont_truncate = true;
    }
}

