/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.AnonChannel;
import anon.TooMuchDataForPacketException;
import anon.client.AbstractDataChannel;
import anon.client.DataChainErrorListener;
import anon.client.DataChainInputStreamQueueEntry;
import anon.client.DataChainSendOrderStructure;
import anon.client.IDataChannelCreator;
import anon.client.IntegrityErrorListener;
import anon.client.InternalChannelMessageQueue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public abstract class AbstractDataChain
implements AnonChannel,
Observer,
Runnable {
    private DataChainInputStreamImplementation m_inputStream;
    private DataChainOutputStreamImplementation m_outputStream;
    private Vector m_messageQueuesNotifications;
    private IDataChannelCreator m_channelCreator;
    private DataChainErrorListener m_errorListener;
    private boolean m_chainClosed;
    private Thread m_downstreamThread;
    private IntegrityErrorListener m_integrityErrorListener;

    public AbstractDataChain(IDataChannelCreator a_channelCreator, DataChainErrorListener a_errorListener, IntegrityErrorListener a_integrityErrorListener) {
        this.m_channelCreator = a_channelCreator;
        this.m_errorListener = a_errorListener;
        this.m_integrityErrorListener = a_integrityErrorListener;
        this.m_inputStream = new DataChainInputStreamImplementation();
        this.m_outputStream = new DataChainOutputStreamImplementation();
        this.m_messageQueuesNotifications = new Vector();
        this.m_chainClosed = false;
        this.m_downstreamThread = new Thread((Runnable)this, "AbstractDataChain: Downstream-Organizer Thread");
        this.m_downstreamThread.setDaemon(true);
        this.m_downstreamThread.start();
    }

    public InputStream getInputStream() {
        return this.m_inputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_outputStream;
    }

    public boolean isClosed() {
        return this.m_chainClosed;
    }

    public void close() {
        if (!this.m_chainClosed) {
            this.m_chainClosed = true;
            try {
                this.getOutputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                this.getInputStream().close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.closeDataChain();
            try {
                this.m_downstreamThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_observedObject, Object a_message) {
        if (a_observedObject instanceof InternalChannelMessageQueue) {
            Vector vector = this.m_messageQueuesNotifications;
            synchronized (vector) {
                this.m_messageQueuesNotifications.addElement(a_observedObject);
                this.m_messageQueuesNotifications.notify();
            }
        }
    }

    protected Vector getMessageQueuesNotificationsList() {
        return this.m_messageQueuesNotifications;
    }

    protected void addInputStreamQueueEntry(DataChainInputStreamQueueEntry a_entry) {
        this.m_inputStream.addToQueue(a_entry);
    }

    protected AbstractDataChannel createDataChannel() {
        return this.m_channelCreator.createDataChannel(this);
    }

    protected void interruptDownstreamThread() {
        this.m_downstreamThread.interrupt();
    }

    protected void propagateConnectionError() {
        this.m_errorListener.dataChainErrorSignaled(null);
    }

    protected void propagateIntegrityError(int a_iErrorCode) {
        this.m_integrityErrorListener.integrityErrorSignaled(a_iErrorCode);
    }

    public abstract int getOutputBlockSize();

    public abstract void createPacketPayload(DataChainSendOrderStructure var1);

    public abstract void run();

    protected abstract void orderPacket(DataChainSendOrderStructure var1);

    protected abstract void outputStreamClosed() throws IOException;

    protected abstract void closeDataChain();

    private class DataChainInputStreamImplementation
    extends InputStream {
        private boolean m_closed = false;
        private Vector m_queueEntries = new Vector();

        private DataChainInputStreamImplementation() {
        }

        public int read() throws IOException {
            byte[] buffer = new byte[1];
            int bytesRead = 0;
            while ((bytesRead = this.read(buffer)) == 0) {
            }
            int returnedByte = -1;
            if (bytesRead == 1) {
                returnedByte = new ByteArrayInputStream(buffer).read();
            }
            return returnedByte;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] a_buffer, int a_offset, int a_length) throws IOException {
            int bytesRead = 0;
            if (a_buffer.length < a_offset) {
                a_offset = a_buffer.length;
            }
            if (a_buffer.length < a_offset + a_length) {
                a_length = a_buffer.length - a_offset;
            }
            if (a_length > 0) {
                Vector vector = this.m_queueEntries;
                synchronized (vector) {
                    if (this.m_closed) {
                        throw new IOException("Stream is closed.");
                    }
                    if (this.m_queueEntries.size() == 0) {
                        try {
                            this.m_queueEntries.wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException("InterruptedException: " + e.toString());
                        }
                    }
                    if (this.m_queueEntries.size() > 0) {
                        DataChainInputStreamQueueEntry currentEntry = (DataChainInputStreamQueueEntry)this.m_queueEntries.firstElement();
                        switch (currentEntry.getType()) {
                            case 2: {
                                bytesRead = -1;
                                break;
                            }
                            case 1: {
                                while (this.m_queueEntries.size() > 0 && currentEntry.getType() == 1 && bytesRead < a_length) {
                                    int bytesToRead = Math.min(a_length - bytesRead, currentEntry.getData().length - currentEntry.getAlreadyReadBytes());
                                    System.arraycopy(currentEntry.getData(), currentEntry.getAlreadyReadBytes(), a_buffer, a_offset + bytesRead, bytesToRead);
                                    bytesRead += bytesToRead;
                                    currentEntry.setAlreadyReadBytes(currentEntry.getAlreadyReadBytes() + bytesToRead);
                                    if (currentEntry.getAlreadyReadBytes() != currentEntry.getData().length) continue;
                                    this.m_queueEntries.removeElementAt(0);
                                    if (this.m_queueEntries.size() <= 0) continue;
                                    currentEntry = (DataChainInputStreamQueueEntry)this.m_queueEntries.firstElement();
                                }
                                break;
                            }
                            case 3: {
                                IOException exceptionToThrow = currentEntry.getIOException();
                                this.m_queueEntries.removeElementAt(0);
                                if (exceptionToThrow == null) break;
                                throw exceptionToThrow;
                            }
                        }
                    }
                }
            }
            return bytesRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            int availableBytes = 0;
            Vector vector = this.m_queueEntries;
            synchronized (vector) {
                if (this.m_closed) {
                    throw new IOException("Stream is closed.");
                }
                if (this.m_queueEntries.size() > 0) {
                    int i = 0;
                    DataChainInputStreamQueueEntry currentEntry = (DataChainInputStreamQueueEntry)this.m_queueEntries.elementAt(i);
                    while (currentEntry != null) {
                        ++i;
                        if (currentEntry.getType() == 1) {
                            availableBytes += currentEntry.getData().length - currentEntry.getAlreadyReadBytes();
                            if (i < this.m_queueEntries.size()) {
                                currentEntry = (DataChainInputStreamQueueEntry)this.m_queueEntries.elementAt(i);
                                continue;
                            }
                            currentEntry = null;
                            continue;
                        }
                        currentEntry = null;
                    }
                }
            }
            return availableBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (!this.m_closed) {
                Vector vector = this.m_queueEntries;
                synchronized (vector) {
                    this.m_closed = true;
                    this.m_queueEntries.removeAllElements();
                    this.m_queueEntries.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addToQueue(DataChainInputStreamQueueEntry a_entry) {
            if (a_entry.getType() == 1 && a_entry.getDataLen() == 0) {
                return;
            }
            Vector vector = this.m_queueEntries;
            synchronized (vector) {
                DataChainInputStreamQueueEntry lastEntry;
                boolean addEntry = true;
                if (this.m_closed) {
                    addEntry = false;
                } else if (this.m_queueEntries.size() > 0 && (lastEntry = (DataChainInputStreamQueueEntry)this.m_queueEntries.lastElement()).getType() == 2) {
                    addEntry = false;
                }
                if (addEntry) {
                    this.m_queueEntries.addElement(a_entry);
                    this.m_queueEntries.notify();
                }
            }
        }
    }

    private class DataChainOutputStreamImplementation
    extends OutputStream {
        private boolean m_closed = false;
        private Object m_internalStreamSynchronization = new Object();

        public void write(int a_byte) throws IOException {
            byte[] byteAsArray = new byte[]{(byte)a_byte};
            this.write(byteAsArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] a_buffer, int a_offset, int a_length) throws IOException {
            Object object = this.m_internalStreamSynchronization;
            synchronized (object) {
                if (this.m_closed) {
                    throw new IOException("Stream is closed.");
                }
                byte[] dataToSend = new byte[a_length];
                System.arraycopy(a_buffer, a_offset, dataToSend, 0, a_length);
                DataChainSendOrderStructure order = new DataChainSendOrderStructure(dataToSend);
                Object object2 = order.getSynchronizationObject();
                synchronized (object2) {
                    AbstractDataChain.this.orderPacket(order);
                    if (!order.isProcessingDone()) {
                        try {
                            order.getSynchronizationObject().wait();
                        }
                        catch (InterruptedException e) {
                            throw new InterruptedIOException("InterruptedException: " + e.toString());
                        }
                    }
                    if (order.getThrownException() != null) {
                        throw order.getThrownException();
                    }
                    if (order.getProcessedBytes() < a_length) {
                        throw new TooMuchDataForPacketException(order.getProcessedBytes());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (!this.m_closed) {
                Object object = this.m_internalStreamSynchronization;
                synchronized (object) {
                    this.m_closed = true;
                    AbstractDataChain.this.outputStreamClosed();
                }
            }
        }
    }
}

