/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public final class DataChannelCipher {
    private GCMBlockCipher m_sendEngine;
    private GCMBlockCipher m_recvEngine;
    private long m_EncMsgCounter = 0L;
    private long m_DecMsgCounter = 0L;
    private AEADParameters m_sendKey;
    private AEADParameters m_recvKey;
    private byte[] m_sendIV;
    private byte[] m_recvIV;
    private boolean m_bSingleKey = false;
    private byte[] m_decryptHelperBuff = new byte[32];

    public DataChannelCipher() {
        this.m_sendEngine = new GCMBlockCipher(new AESFastEngine());
        this.m_recvEngine = new GCMBlockCipher(new AESFastEngine());
        this.m_sendIV = new byte[12];
        this.m_recvIV = new byte[12];
    }

    private synchronized int setSendKey(byte[] key, int offset, int len) {
        try {
            this.m_sendKey = new AEADParameters(new KeyParameter(key, offset, len), 128, this.m_sendIV, null);
            this.m_EncMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private synchronized int setRecvKey(byte[] key, int offset, int len) {
        try {
            this.m_recvKey = new AEADParameters(new KeyParameter(key, offset, len), 128, this.m_recvIV, null);
            this.m_DecMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] keys) {
        return this.setEncryptionKeysAES(keys, 0, keys.length);
    }

    public synchronized int setEncryptionKeysAES(byte[] keys, int offset, int keylen) {
        try {
            int ret2;
            int ret1;
            if (keylen == 16) {
                this.m_bSingleKey = true;
                ret1 = this.setSendKey(keys, offset, 16);
                ret2 = this.setRecvKey(keys, offset, 16);
            } else {
                this.m_bSingleKey = false;
                ret1 = this.setSendKey(keys, offset, 16);
                ret2 = this.setRecvKey(keys, offset + 16, 16);
            }
            if (ret1 == 0 && ret2 == 0) {
                return 0;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public byte[] getKeys() {
        try {
            if (this.m_sendKey == null || this.m_recvKey == null) {
                return null;
            }
            if (this.m_bSingleKey) {
                return this.m_sendKey.getKey().getKey();
            }
            byte[] keys = new byte[32];
            System.arraycopy(this.m_sendKey.getKey().getKey(), 0, keys, 0, 16);
            System.arraycopy(this.m_recvKey.getKey().getKey(), 0, keys, 16, 16);
            return keys;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void createIV(byte[] iv, long counter) {
        iv[8] = (byte)(counter >> 24 & 0xFFL);
        iv[9] = (byte)(counter >> 16 & 0xFFL);
        iv[10] = (byte)(counter >> 8 & 0xFFL);
        iv[11] = (byte)(counter & 0xFFL);
    }

    public void encryptGCM1(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        DataChannelCipher.createIV(this.m_sendIV, this.m_EncMsgCounter);
        ++this.m_EncMsgCounter;
        this.m_sendEngine.init(true, this.m_sendKey);
        int outlen = this.m_sendEngine.processBytes(from, ifrom, len, to, ito);
        this.m_sendEngine.doFinal(to, ito + outlen);
    }

    public void decryptGCM2(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        DataChannelCipher.createIV(this.m_recvIV, this.m_DecMsgCounter);
        ++this.m_DecMsgCounter;
        this.m_recvEngine.init(false, this.m_recvKey);
        this.m_recvEngine.processBytes(from, ifrom, 32, this.m_decryptHelperBuff, 0);
        int payloadLen = this.m_decryptHelperBuff[0] << 8 & 0x3F00 | this.m_decryptHelperBuff[1] & 0xFF;
        this.m_recvEngine.reset();
        int declen = this.m_recvEngine.processBytes(from, ifrom, payloadLen + 19, to, ito);
        this.m_recvEngine.doFinal(to, ito + declen);
    }

    public static int getMACSize() {
        return 16;
    }
}

