/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPublicKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import anon.crypto.MyDSAParams;
import anon.crypto.MyDSASignature;
import anon.util.Base64;
import anon.util.XMLUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MyDSAPublicKey
extends AbstractPublicKey
implements DSAPublicKey,
IMyPublicKey {
    private BigInteger m_Y;
    private MyDSAParams m_params;
    private long m_hashValue = 0L;

    public MyDSAPublicKey(DSAPublicKeyParameters params) {
        this.m_Y = params.getY();
        this.m_params = new MyDSAParams(params.getParameters());
    }

    public MyDSAPublicKey(SubjectPublicKeyInfo info) throws IllegalArgumentException {
        try {
            DSAParameter params = DSAParameter.getInstance(info.getAlgorithm().getParameters());
            ASN1Integer derY = null;
            derY = (ASN1Integer)info.parsePublicKey();
            this.m_Y = derY.getValue();
            this.m_params = new MyDSAParams(params);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
    }

    public ISignatureVerificationAlgorithm getSignatureAlgorithm() {
        try {
            MyDSASignature algorithm = new MyDSASignature();
            algorithm.initVerify(this);
            return algorithm;
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public BigInteger getY() {
        return this.m_Y;
    }

    public DSAParams getParams() {
        return this.m_params;
    }

    public DSAPublicKeyParameters getPublicParams() {
        return new DSAPublicKeyParameters(this.m_Y, (DSAParameters)this.m_params);
    }

    public MyDSAParams getMyDASParams() {
        return this.m_params;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public SubjectPublicKeyInfo getAsSubjectPublicKeyInfo() {
        ASN1Primitive asn1Param = new DSAParameter(this.m_params.getP(), this.m_params.getQ(), this.m_params.getG()).toASN1Primitive();
        AlgorithmIdentifier algID = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, asn1Param);
        try {
            return new SubjectPublicKeyInfo(algID, new ASN1Integer(this.getY()));
        }
        catch (Throwable e) {
            return null;
        }
    }

    public Element toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("DSAKeyValue");
        Element elem = null;
        elem = a_doc.createElement("Y");
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_Y.toByteArray()));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("P");
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getP().toByteArray()));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Q");
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getQ().toByteArray()));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("G");
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getG().toByteArray()));
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public boolean equals(Object a_publicKey) {
        if (a_publicKey == null) {
            return false;
        }
        if (!(a_publicKey instanceof DSAPublicKey)) {
            return false;
        }
        DSAPublicKey d = (DSAPublicKey)a_publicKey;
        return d.getY().equals(this.m_Y) && d.getParams().equals(this.m_params);
    }

    public int hashCode() {
        if (this.m_hashValue == 0L) {
            this.m_hashValue = this.m_Y.longValue() + this.m_params.getG().longValue() + this.m_params.getP().longValue() + this.m_params.getQ().longValue();
        }
        return (int)this.m_hashValue;
    }

    public int getKeyLength() {
        int len = this.m_Y.toByteArray().length * 8;
        return len - len % 64;
    }

    public int getParameterLength() {
        return (this.m_params.getG().toByteArray().length + this.m_params.getP().toByteArray().length + this.m_params.getQ().toByteArray().length) * 8;
    }
}

