/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.MyRSAPrivateKey;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class RSAKeyPair
extends AsymmetricCryptoKeyPair {
    public static final int KEY_LENGTH_2048 = 2048;

    public RSAKeyPair(MyRSAPrivateKey a_privateKey) {
        super(a_privateKey);
    }

    public static RSAKeyPair getInstance(BigInteger a_publicExponent, SecureRandom a_random, int a_strength, int a_certainty) {
        RSAKeyPair keyPair;
        RSAKeyPairGenerator pGen = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters genParam = new RSAKeyGenerationParameters(a_publicExponent, a_random, a_strength, a_certainty);
        pGen.init(genParam);
        AsymmetricCipherKeyPair pair = pGen.generateKeyPair();
        try {
            keyPair = new RSAKeyPair(new MyRSAPrivateKey((RSAPrivateCrtKeyParameters)pair.getPrivate()));
        }
        catch (Exception a_e) {
            keyPair = null;
        }
        if (!AsymmetricCryptoKeyPair.isValidKeyPair(keyPair)) {
            return null;
        }
        return keyPair;
    }

    public static RSAKeyPair getInstance(SecureRandom a_random, int a_strength, int a_certainty) {
        return RSAKeyPair.getInstance(new BigInteger("65537"), a_random, a_strength, a_certainty);
    }
}

