/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;

public class X509BasicConstraints
extends AbstractX509Extension {
    public static final String IDENTIFIER = Extension.basicConstraints.getId();
    private boolean m_cA;
    private int m_pathLenConstraint = -1;

    public X509BasicConstraints(boolean cA) {
        super(IDENTIFIER, true, X509BasicConstraints.createDEROctets(cA));
        this.m_cA = cA;
    }

    public X509BasicConstraints(int pathLenConstraint) {
        super(IDENTIFIER, true, X509BasicConstraints.createDEROctets(pathLenConstraint));
        this.m_cA = true;
        this.m_pathLenConstraint = pathLenConstraint;
    }

    public X509BasicConstraints(ASN1Sequence a_extension) {
        super(a_extension);
        this.createValue();
    }

    private static byte[] createDEROctets(int pathLenConstraint) {
        try {
            return new BasicConstraints(pathLenConstraint).getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    private static byte[] createDEROctets(boolean cA) {
        try {
            return new BasicConstraints(cA).getEncoded("DER");
        }
        catch (IOException e) {
            return null;
        }
    }

    private void createValue() {
        try {
            BasicConstraints bc = BasicConstraints.getInstance(new ASN1InputStream(new ByteArrayInputStream(this.getDEROctets())).readObject());
            this.m_cA = bc.isCA();
            BigInteger pathLenConstraint = bc.getPathLenConstraint();
            if (pathLenConstraint != null) {
                this.m_pathLenConstraint = bc.getPathLenConstraint().intValue();
            }
        }
        catch (Exception a_e) {
            a_e.printStackTrace();
            throw new RuntimeException("Could not read basic constraints from byte array!");
        }
    }

    public boolean isCA() {
        return this.m_cA;
    }

    public int getPathLengthConstraint() {
        return this.m_pathLenConstraint;
    }

    public String getName() {
        return "BasicConstraints";
    }

    public Vector getValues() {
        Vector<String> v = new Vector<String>();
        v.addElement(new String("cA=" + this.m_cA));
        if (this.m_pathLenConstraint != -1) {
            v.addElement(new String("pathLenConstraint=" + this.m_pathLenConstraint));
        }
        return v;
    }
}

