/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.crypto.AbstractX509AlternativeName;
import anon.crypto.ICertificate;
import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.X509BasicConstraints;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectAlternativeName;
import anon.util.CountryMapper;
import java.util.Vector;
import mixconfig.ICertificateView;

public class OperatorCertificateView
implements ICertificateView {
    private boolean m_bCA;
    private CountryMapper m_CountryMapper;
    private String m_strOrganisation;
    private String m_strOrgaUnit;
    private String m_strEMail;
    private String m_strURL;
    private String m_strCommonName;

    public OperatorCertificateView() {
        this.update(null);
    }

    @Override
    public void update(ICertificate a_certificate) {
        if (a_certificate == null) {
            this.m_bCA = false;
            this.m_CountryMapper = new CountryMapper();
            this.m_strOrganisation = "";
            this.m_strOrgaUnit = "";
            this.m_strEMail = "";
            this.m_strURL = "";
            this.m_strCommonName = "";
            return;
        }
        JAPCertificate certificate = a_certificate.getX509Certificate();
        X509DistinguishedName dn = certificate.getSubject();
        try {
            this.m_CountryMapper = new CountryMapper(dn.getCountryCode());
        }
        catch (IllegalArgumentException a_e) {
            // empty catch block
        }
        X509BasicConstraints extConstraints = (X509BasicConstraints)certificate.getExtensions().getExtension(X509BasicConstraints.IDENTIFIER);
        this.m_bCA = extConstraints != null && extConstraints.isCA();
        this.m_strOrganisation = this.formatDNField(dn.getOrganisation());
        this.m_strCommonName = this.formatDNField(dn.getCommonName());
        this.m_strOrgaUnit = this.formatDNField(dn.getOrganisationalUnit());
        MyX509Extensions extensions = a_certificate.getX509Certificate().getExtensions();
        this.m_strURL = "";
        this.m_strEMail = "";
        if (this.m_strEMail.length() == 0) {
            this.m_strEMail = this.formatDNField(dn.getE_EmailAddress());
            if (this.m_strEMail.length() == 0) {
                this.m_strEMail = this.formatDNField(dn.getEmailAddress());
            }
        }
        for (int i = 0; i < extensions.getSize(); ++i) {
            if (!(extensions.getExtension(i) instanceof X509SubjectAlternativeName)) continue;
            Vector vecTags = ((X509SubjectAlternativeName)extensions.getExtension(i)).getTags();
            Vector vecValues = extensions.getExtension(i).getValues();
            for (int j = 0; j < vecTags.size() && j < vecValues.size() && (this.m_strEMail.length() == 0 || this.m_strURL.length() == 0); ++j) {
                if (this.m_strEMail.length() == 0 && vecTags.elementAt(j).equals(AbstractX509AlternativeName.TAG_EMAIL)) {
                    this.m_strEMail = this.formatDNField(vecValues.elementAt(j).toString());
                }
                if (this.m_strURL.length() != 0 || !vecTags.elementAt(j).equals(AbstractX509AlternativeName.TAG_URL)) continue;
                this.m_strURL = this.formatDNField(vecValues.elementAt(j).toString());
            }
        }
    }

    public String getOrganisation() {
        return this.m_strOrganisation;
    }

    public String getOrganisationalUnit() {
        return this.m_strOrgaUnit;
    }

    public CountryMapper getCountryMapper() {
        return this.m_CountryMapper;
    }

    public boolean isCA() {
        return this.m_bCA;
    }

    public String getCommonName() {
        return this.m_strCommonName;
    }

    public String getCountry() {
        if (this.m_CountryMapper.getISOCode().length() == 0) {
            return "";
        }
        return this.m_CountryMapper.toString();
    }

    public String getEMail() {
        return this.m_strEMail;
    }

    public String getURL() {
        return this.m_strURL;
    }

    private String formatDNField(String a_strDNField) {
        if (a_strDNField == null) {
            a_strDNField = "";
        }
        return a_strDNField.trim();
    }
}

