/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.crypto.MyRSAPrivateKey;
import anon.crypto.PKCS12;
import anon.util.IMiscPasswordReader;
import gui.JAPJIntField;
import gui.dialog.JAPDialog;
import gui.dialog.PasswordContentPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mixconfig.MixConfig;
import mixconfig.tools.dataretention.DataRetentionLogFile;
import mixconfig.tools.dataretention.DataRetentionLogFileEntry;
import mixconfig.tools.dataretention.DataRetentionLogFileHeader;
import mixconfig.tools.dataretention.DataRetentionSmartCard;
import mixconfig.tools.dataretention.JTreeTable;
import mixconfig.tools.dataretention.LogFilesModel;

public class DataRetentionLogDecrypt
extends JAPDialog {
    JAPJIntField m_tfDay;
    JAPJIntField m_tfYear;
    JAPJIntField m_tfMonth;
    JAPJIntField m_tfHour;
    JAPJIntField m_tfSecond;
    JAPJIntField m_tfMinute;
    private String m_privateKeyFile;
    private JLabel m_labelPrivateKeyStorage;
    private boolean m_bUseSmartCardforPrivateKey;
    private JTextField m_tfLogDir;

    public DataRetentionLogDecrypt(Frame parent) {
        super(parent, "Proccessing Tool for retained Data", true);
        this.initComponents();
        this.pack();
        this.setVisible(true, false);
    }

    private void initComponents() {
        GridBagConstraints constraintsContentPane = new GridBagConstraints();
        GridBagConstraints constraintsPanel = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel panelLogfile = new JPanel(new GridBagLayout());
        panelLogfile.setBorder(new TitledBorder("Allgemeine Angaben"));
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 0;
        constraintsContentPane.anchor = 17;
        constraintsContentPane.weightx = 1.0;
        constraintsContentPane.fill = 2;
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)panelLogfile, constraintsContentPane);
        JLabel label = new JLabel("Verzeichnis der Logdateien:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 0;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        panelLogfile.add((Component)label, constraintsPanel);
        label = new JLabel("Schluesselspeicher:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        panelLogfile.add((Component)label, constraintsPanel);
        this.m_tfLogDir = new JTextField(30);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        panelLogfile.add((Component)this.m_tfLogDir, constraintsPanel);
        this.m_labelPrivateKeyStorage = new JLabel();
        Font f = this.m_labelPrivateKeyStorage.getFont();
        this.m_labelPrivateKeyStorage.setFont(f.deriveFont(1));
        this.m_labelPrivateKeyStorage.setForeground(Color.blue);
        this.setPrivateKeyFile(false, this.m_privateKeyFile);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 1;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        panelLogfile.add((Component)this.m_labelPrivateKeyStorage, constraintsPanel);
        JButton bttn = new JButton("Select...");
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataRetentionLogDecrypt.this.doSelectLogDir();
            }
        });
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        panelLogfile.add((Component)bttn, constraintsPanel);
        bttn = new JButton("Select...");
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataRetentionLogDecrypt.this.doSelectSecretKey();
            }
        });
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 1;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        panelLogfile.add((Component)bttn, constraintsPanel);
        JPanel panelRequest = new JPanel(new GridBagLayout());
        panelRequest.setBorder(new TitledBorder("Anfrage"));
        constraintsContentPane.gridy = 1;
        this.getContentPane().add((Component)panelRequest, constraintsContentPane);
        label = new JLabel("Datum:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 0;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        panelRequest.add((Component)label, constraintsPanel);
        label = new JLabel("Uhrzeit:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        panelRequest.add((Component)label, constraintsPanel);
        this.m_tfDay = new JAPJIntField(31);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfDay, constraintsPanel);
        this.m_tfMonth = new JAPJIntField(12);
        constraintsPanel.gridx = 3;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfMonth, constraintsPanel);
        this.m_tfYear = new JAPJIntField(2050);
        constraintsPanel.gridx = 5;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfYear, constraintsPanel);
        this.m_tfHour = new JAPJIntField(23);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 1;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfHour, constraintsPanel);
        this.m_tfMinute = new JAPJIntField(59);
        constraintsPanel.gridx = 3;
        constraintsPanel.gridy = 1;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfMinute, constraintsPanel);
        this.m_tfSecond = new JAPJIntField(59);
        constraintsPanel.gridx = 5;
        constraintsPanel.gridy = 1;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)this.m_tfSecond, constraintsPanel);
        label = new JLabel(".");
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 0;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(0, 0, 0, 0);
        panelRequest.add((Component)label, constraintsPanel);
        label = new JLabel(".");
        constraintsPanel.gridx = 4;
        constraintsPanel.gridy = 0;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        panelRequest.add((Component)label, constraintsPanel);
        label = new JLabel(":");
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        panelRequest.add((Component)label, constraintsPanel);
        label = new JLabel(":");
        constraintsPanel.gridx = 4;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        panelRequest.add((Component)label, constraintsPanel);
        JComboBox<String> cb = new JComboBox<String>();
        cb.setEditable(false);
        cb.addItem("UTC");
        constraintsPanel.gridx = 6;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        panelRequest.add(cb, constraintsPanel);
        label = new JLabel();
        constraintsPanel.gridx = 7;
        constraintsPanel.gridy = 1;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 1.0;
        panelRequest.add((Component)label, constraintsPanel);
        bttn = new JButton("Verify Log Files...");
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataRetentionLogDecrypt.this.doVerifyLogFiles();
            }
        });
        constraintsPanel.gridx = 8;
        constraintsPanel.gridy = 2;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.ipadx = 10;
        constraintsPanel.ipady = 10;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)bttn, constraintsPanel);
        bttn = new JButton("Search Records...");
        bttn.setFont(bttn.getFont().deriveFont(1));
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    DataRetentionLogDecrypt.this.doLogDecrpyt();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        constraintsPanel.gridx = 9;
        constraintsPanel.gridy = 2;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.ipadx = 10;
        constraintsPanel.ipady = 10;
        constraintsPanel.fill = 2;
        panelRequest.add((Component)bttn, constraintsPanel);
        JPanel panelResult = new JPanel(new GridBagLayout());
        panelResult.setBorder(new TitledBorder("Ergebnis"));
        constraintsContentPane.gridy = 2;
        constraintsContentPane.weighty = 1.0;
        constraintsContentPane.fill = 1;
        this.getContentPane().add((Component)panelResult, constraintsContentPane);
        JTreeTable treetable = new JTreeTable(new LogFilesModel());
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.weighty = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 1;
        panelResult.add((Component)new JScrollPane(treetable), constraintsPanel);
        JPanel panelButtons = new JPanel(new GridLayout(1, 2, 20, 0));
        constraintsContentPane.gridy = 3;
        constraintsContentPane.weighty = 0.0;
        constraintsContentPane.fill = 0;
        constraintsContentPane.anchor = 14;
        this.getContentPane().add((Component)panelButtons, constraintsContentPane);
        bttn = new JButton("Ergebnis speichern ...");
        panelButtons.add(bttn);
        bttn = new JButton("Beenden");
        panelButtons.add(bttn);
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataRetentionLogDecrypt.this.dispose();
            }
        });
    }

    private Object doSetSecretPrivateKey() {
        if (!this.m_bUseSmartCardforPrivateKey) {
            MyRSAPrivateKey privKey;
            Object smartcard = null;
            PKCS12 pkcs12 = null;
            File filePrivKey = null;
            try {
                filePrivKey = new File(this.m_privateKeyFile);
                if (!filePrivKey.isFile() || !filePrivKey.canRead()) {
                    this.doErrorPrivKey(this);
                    return null;
                }
            }
            catch (Exception e) {
                this.doErrorPrivKey(this);
                return null;
            }
            try {
                while (true) {
                    JAPDialog dlg = new JAPDialog(this, "Password for private key");
                    PasswordContentPane passwd = new PasswordContentPane(dlg, 2, "Password");
                    passwd.updateDialog();
                    dlg.pack();
                    pkcs12 = PKCS12.getInstance((InputStream)new FileInputStream(filePrivKey), (IMiscPasswordReader)passwd);
                    if (pkcs12 != null || passwd.getButtonValue() == 2) break;
                    dlg.dispose();
                }
                if (pkcs12 == null) {
                    return null;
                }
                privKey = (MyRSAPrivateKey)pkcs12.getPrivateKey();
            }
            catch (Exception e1) {
                this.doErrorPrivKey(this);
                return null;
            }
            return privKey;
        }
        Object privKey = null;
        DataRetentionSmartCard smartcard = new DataRetentionSmartCard();
        boolean bFoundCard = false;
        try {
            bFoundCard = smartcard.connectToSmartCard();
            smartcard.retrievePublicKey();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (!bFoundCard) {
            this.doErrorSmartCard(this);
            return null;
        }
        boolean bUserAuth = false;
        try {
            do {
                JAPDialog dlg = new JAPDialog(this, "Password for SamrtCard");
                PasswordContentPane passwd = new PasswordContentPane(dlg, 2, "Password");
                passwd.updateDialog();
                dlg.pack();
                dlg.setVisible(true);
                dlg.dispose();
                if (passwd.getButtonValue() == 2) {
                    return null;
                }
                byte[] pin = new String(passwd.getPassword()).getBytes();
                try {
                    bUserAuth = smartcard.authenticateUser(pin);
                }
                catch (Exception e) {
                    bUserAuth = false;
                }
            } while (!bUserAuth);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
        return smartcard;
    }

    private void doVerifyLogFiles() {
        DataRetentionSmartCard smartcard;
        MyRSAPrivateKey privKey;
        Object oPrivKeyOrSmartCard = this.doSetSecretPrivateKey();
        if (oPrivKeyOrSmartCard == null) {
            return;
        }
        if (oPrivKeyOrSmartCard instanceof DataRetentionSmartCard) {
            privKey = null;
            smartcard = (DataRetentionSmartCard)oPrivKeyOrSmartCard;
        } else {
            smartcard = null;
            privKey = (MyRSAPrivateKey)oPrivKeyOrSmartCard;
        }
        final JAPDialog dlgVerify = new JAPDialog(this, "Verify Log Files");
        Container contentPane = dlgVerify.getContentPane();
        GridBagConstraints constraintsContentPane = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("Verify"));
        JLabel label = new JLabel("Verify File:");
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        constraintsContentPane.anchor = 18;
        constraintsContentPane.weighty = 0.0;
        panel.add((Component)label, constraintsContentPane);
        final JLabel labelCurrentFile = new JLabel();
        constraintsContentPane.gridx = 1;
        constraintsContentPane.fill = 2;
        constraintsContentPane.weightx = 1.0;
        panel.add((Component)labelCurrentFile, constraintsContentPane);
        label = new JLabel("Status:");
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 1;
        constraintsContentPane.weightx = 0.0;
        panel.add((Component)label, constraintsContentPane);
        final JLabel labelCurrentFileStatus = new JLabel();
        constraintsContentPane.gridx = 1;
        constraintsContentPane.weightx = 1.0;
        panel.add((Component)labelCurrentFileStatus, constraintsContentPane);
        final JProgressBar pbFiles = new JProgressBar();
        pbFiles.setMinimum(0);
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 2;
        constraintsContentPane.gridwidth = 2;
        constraintsContentPane.weightx = 1.0;
        constraintsContentPane.weighty = 1.0;
        panel.add((Component)pbFiles, constraintsContentPane);
        constraintsContentPane.gridy = 0;
        constraintsContentPane.weightx = 1.0;
        constraintsContentPane.weighty = 0.0;
        constraintsContentPane.fill = 1;
        constraintsContentPane.fill = 2;
        contentPane.add((Component)panel, constraintsContentPane);
        panel = new JPanel();
        panel.setBorder(new TitledBorder("Results"));
        JTable tableVerify = new JTable();
        final DefaultTableModel model = new DefaultTableModel();
        model.addColumn("File");
        model.addColumn("Header");
        model.addColumn("Log Lines");
        model.addColumn("Footer");
        tableVerify.setModel(model);
        JScrollPane sp = new JScrollPane(tableVerify);
        panel.add(sp);
        constraintsContentPane.gridy = 1;
        constraintsContentPane.fill = 1;
        constraintsContentPane.weighty = 1.0;
        contentPane.add((Component)panel, constraintsContentPane);
        final JButton bttnClose = new JButton("Cancel");
        constraintsContentPane.gridy = 2;
        constraintsContentPane.fill = 0;
        constraintsContentPane.weighty = 0.0;
        constraintsContentPane.weightx = 0.0;
        constraintsContentPane.anchor = 14;
        contentPane.add((Component)bttnClose, constraintsContentPane);
        class CRunnableDoVerify
        implements Runnable {
            volatile boolean bRun;

            CRunnableDoVerify() {
            }

            public void stopIt() {
                this.bRun = false;
            }

            @Override
            public void run() {
                this.bRun = true;
                File[] logFiles = null;
                try {
                    File dir = new File(DataRetentionLogDecrypt.this.m_tfLogDir.getText());
                    if (!dir.isDirectory() || !dir.canRead()) {
                        DataRetentionLogDecrypt.this.doErrorLogDir();
                        return;
                    }
                    logFiles = dir.listFiles();
                }
                catch (Exception e) {
                    DataRetentionLogDecrypt.this.doErrorLogDir();
                    return;
                }
                pbFiles.setMaximum(logFiles.length);
                for (File logFile : logFiles) {
                    if (!this.bRun) break;
                    if (logFile.isFile()) {
                        boolean bSkipNext = false;
                        labelCurrentFile.setText(logFile.getName());
                        Object[] rowEntries = new String[model.getColumnCount()];
                        rowEntries[0] = logFile.getName();
                        model.addRow(rowEntries);
                        labelCurrentFileStatus.setText("Parse Header");
                        DataRetentionLogFile anonLogFile = null;
                        try {
                            anonLogFile = new DataRetentionLogFile(logFile);
                        }
                        catch (Exception e) {
                            labelCurrentFileStatus.setText("Error while parsing Header: " + e.getMessage());
                            model.setValueAt("failed", model.getRowCount() - 1, 1);
                            bSkipNext = true;
                        }
                        if (!bSkipNext) {
                            byte[] encKey = anonLogFile.getEncryptedKey(0);
                            byte[] symKey = null;
                            labelCurrentFileStatus.setText("Try to decrypt symmetric key");
                            if (DataRetentionLogDecrypt.this.m_bUseSmartCardforPrivateKey) {
                                try {
                                    symKey = smartcard.decrpytSymmetricKey(encKey);
                                }
                                catch (Exception e) {
                                    labelCurrentFileStatus.setText("Error while getting symmetric Key: " + e.getMessage());
                                    bSkipNext = true;
                                }
                            } else {
                                try {
                                    symKey = DataRetentionLogFileHeader.decryptSymKey(encKey, privKey);
                                }
                                catch (Exception e) {
                                    labelCurrentFileStatus.setText("Error while getting symmetric Key: " + e.getMessage());
                                    bSkipNext = true;
                                }
                            }
                            if (symKey == null) {
                                labelCurrentFileStatus.setText("Error while getting symmetric Key: Sym key is NULL");
                                bSkipNext = true;
                            } else {
                                anonLogFile.setDecryptionKey(symKey);
                            }
                        }
                        if (!bSkipNext) {
                            labelCurrentFileStatus.setText("Try to verify log file header");
                            try {
                                anonLogFile.verifyHeader();
                            }
                            catch (Exception e) {
                                labelCurrentFileStatus.setText("Couldt not verify header: " + e.getMessage());
                                model.setValueAt("failed", model.getRowCount() - 1, 1);
                            }
                            model.setValueAt("ok", model.getRowCount() - 1, 1);
                            labelCurrentFileStatus.setText("Try to verify log file footer");
                            try {
                                anonLogFile.verifyFooter();
                            }
                            catch (Exception e) {
                                labelCurrentFileStatus.setText("Couldt not verify footer: " + e.getMessage());
                                model.setValueAt("failed", model.getRowCount() - 1, 3);
                            }
                            model.setValueAt("ok", model.getRowCount() - 1, 3);
                            int lines = anonLogFile.getNrOfLogLines();
                            System.out.println("Number of Log entries per log line: " + anonLogFile.getHeader().getNrOfLogEntriesPerLogLine());
                            System.out.println("Log line size: " + anonLogFile.getHeader().getSizeOfLogLine());
                            labelCurrentFileStatus.setText("Try to verify log line 1/" + lines);
                            int goodLines = 0;
                            int badLines = 0;
                            try {
                                anonLogFile.verifyFirstLogLine();
                                ++goodLines;
                            }
                            catch (Exception e) {
                                labelCurrentFileStatus.setText("Try to verify log line 1/" + lines + " (1 Error, last error message: " + e.getMessage() + ")");
                                ++badLines;
                            }
                            for (int i = 2; i <= lines && this.bRun; ++i) {
                                labelCurrentFileStatus.setText("Try to verify log line " + i + "/" + lines);
                                try {
                                    anonLogFile.verifyNextLogLine();
                                    ++goodLines;
                                    continue;
                                }
                                catch (Exception e) {
                                    labelCurrentFileStatus.setText("Try to verify log line " + i + "/" + lines + " (1 Error, last error message: " + e.getMessage() + ")");
                                    ++badLines;
                                }
                            }
                            model.setValueAt(goodLines + " ok / " + badLines + " failed", model.getRowCount() - 1, 2);
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    pbFiles.setValue(pbFiles.getValue() + 1);
                }
                bttnClose.setText("Close");
            }
        }
        final CRunnableDoVerify runnableDoVerify = new CRunnableDoVerify();
        final Thread threadDoVerify = new Thread(runnableDoVerify);
        bttnClose.addActionListener(new ActionListener(){
            {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                runnableDoVerify.stopIt();
                try {
                    threadDoVerify.join();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                dlgVerify.dispose();
            }
        });
        threadDoVerify.setDaemon(true);
        threadDoVerify.start();
        dlgVerify.setDefaultCloseOperation(0);
        dlgVerify.pack();
        dlgVerify.setVisible(true);
    }

    private void doErrorPrivKey(JAPDialog parent) {
        JAPDialog.showErrorDialog(parent, "The given private key could not be read. Plaese check if the provided location is correct.");
    }

    private void doErrorSmartCard(JAPDialog parent) {
        JAPDialog.showErrorDialog(parent, "Could not find any SmartCard reader which contains a valid SmartCard. Plaese check your readers and the inserted SmartCard");
    }

    private void doErrorLogDir() {
        JAPDialog.showErrorDialog((JAPDialog)this, "The given log dir could not be read. Plaese check if the provided location is correct.");
    }

    private void doSelectLogDir() {
        File f;
        JFileChooser fileChosser = MixConfig.showFileDialog(this.getOwner(), 3, 0);
        if (fileChosser != null && (f = fileChosser.getSelectedFile()) != null) {
            this.m_tfLogDir.setText(f.getAbsolutePath());
        }
    }

    protected void doLogDecrpyt() throws Exception {
        DataRetentionSmartCard smartcard;
        MyRSAPrivateKey privKey;
        Object oPrivKeyOrSmartCard = this.doSetSecretPrivateKey();
        if (oPrivKeyOrSmartCard == null) {
            return;
        }
        if (oPrivKeyOrSmartCard instanceof DataRetentionSmartCard) {
            privKey = null;
            smartcard = (DataRetentionSmartCard)oPrivKeyOrSmartCard;
        } else {
            smartcard = null;
            privKey = (MyRSAPrivateKey)oPrivKeyOrSmartCard;
        }
        File[] logFiles = null;
        try {
            File dir = new File(this.m_tfLogDir.getText());
            if (!dir.isDirectory() || !dir.canRead()) {
                this.doErrorLogDir();
                return;
            }
            logFiles = dir.listFiles();
        }
        catch (Exception e) {
            this.doErrorLogDir();
            return;
        }
        for (File logFile : logFiles) {
            if (!logFile.isFile()) continue;
            DataRetentionLogFile anonLogFile = new DataRetentionLogFile(logFile);
            byte[] encKey = anonLogFile.getEncryptedKey(0);
            byte[] symKey = null;
            if (this.m_bUseSmartCardforPrivateKey) {
                try {
                    symKey = smartcard.decrpytSymmetricKey(encKey);
                }
                catch (Exception e) {}
            } else {
                try {
                    symKey = DataRetentionLogFileHeader.decryptSymKey(encKey, privKey);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            anonLogFile.setDecryptionKey(symKey);
            Date d = new Date(this.m_tfYear.getInt() - 1900, this.m_tfMonth.getInt() - 1, this.m_tfDay.getInt(), this.m_tfHour.getInt(), this.m_tfMinute.getInt(), this.m_tfSecond.getInt());
            DataRetentionLogFileEntry[] entriesFound = anonLogFile.search(d.getTime() / 1000L, 10);
            if (entriesFound == null) continue;
            for (int i = 0; i < entriesFound.length; ++i) {
                System.out.println(i + 1 + ". entry: " + entriesFound[i].toString());
            }
        }
    }

    private void doSelectSecretKey() {
        final JAPDialog dlgKeySelect = new JAPDialog(this, "Select Secret Key Storage");
        Container contentPane = dlgKeySelect.getContentPane();
        GridBagConstraints constraintsContentPane = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        JRadioButton radiobttnStoreDisk = new JRadioButton("Stored on disk / USB-Stick etc.");
        final JRadioButton radiobttnStoreSmartCard = new JRadioButton("Stored on SmartCard");
        ButtonGroup bttngrpStore = new ButtonGroup();
        bttngrpStore.add(radiobttnStoreDisk);
        bttngrpStore.add(radiobttnStoreSmartCard);
        radiobttnStoreDisk.setSelected(true);
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 0;
        constraintsContentPane.gridwidth = 3;
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        constraintsContentPane.anchor = 18;
        contentPane.add((Component)radiobttnStoreDisk, constraintsContentPane);
        JLabel label = new JLabel("Secret key file:");
        constraintsContentPane.gridy = 1;
        constraintsContentPane.gridwidth = 1;
        constraintsContentPane.insets = new Insets(0, 30, 10, 10);
        constraintsContentPane.anchor = 17;
        contentPane.add((Component)label, constraintsContentPane);
        final JTextField tfSecretKeyFile = new JTextField(30);
        tfSecretKeyFile.setText(this.m_privateKeyFile);
        constraintsContentPane.gridx = 1;
        constraintsContentPane.weightx = 1.0;
        constraintsContentPane.fill = 2;
        constraintsContentPane.insets = new Insets(0, 0, 10, 10);
        contentPane.add((Component)tfSecretKeyFile, constraintsContentPane);
        JButton bttnSelect = new JButton("Select...");
        bttnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                File f;
                JFileChooser fileChosser = MixConfig.showFileDialog(dlgKeySelect.getOwner(), 2, 4);
                if (fileChosser != null && (f = fileChosser.getSelectedFile()) != null) {
                    tfSecretKeyFile.setText(f.getAbsolutePath());
                }
            }
        });
        constraintsContentPane.gridx = 2;
        constraintsContentPane.weightx = 0.0;
        constraintsContentPane.insets = new Insets(0, 10, 10, 10);
        contentPane.add((Component)bttnSelect, constraintsContentPane);
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 2;
        constraintsContentPane.gridwidth = 3;
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        constraintsContentPane.anchor = 18;
        contentPane.add((Component)radiobttnStoreSmartCard, constraintsContentPane);
        JButton bttnOk = new JButton("Ok");
        bttnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DataRetentionLogDecrypt.this.setPrivateKeyFile(radiobttnStoreSmartCard.isSelected(), tfSecretKeyFile.getText());
                dlgKeySelect.dispose();
            }
        });
        constraintsContentPane.fill = 0;
        constraintsContentPane.gridx = 0;
        constraintsContentPane.gridy = 3;
        constraintsContentPane.gridwidth = 3;
        constraintsContentPane.insets = new Insets(10, 10, 10, 10);
        constraintsContentPane.anchor = 12;
        contentPane.add((Component)bttnOk, constraintsContentPane);
        dlgKeySelect.pack();
        dlgKeySelect.setVisible(true);
    }

    private void setPrivateKeyFile(boolean bSmartCard, String text) {
        this.m_bUseSmartCardforPrivateKey = bSmartCard;
        if (bSmartCard) {
            this.m_labelPrivateKeyStorage.setText("SmartCard");
            return;
        }
        if (text == null || text.length() == 0) {
            this.m_labelPrivateKeyStorage.setText("Unspecified");
            this.m_privateKeyFile = null;
        } else {
            this.m_labelPrivateKeyStorage.setText(text);
            this.m_privateKeyFile = text;
        }
    }
}

