/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;

public class SymCipher {
    AESFastEngine m_aesEngine1 = new AESFastEngine();
    AESFastEngine m_aesEngine2 = new AESFastEngine();
    byte[] m_iv1 = new byte[16];
    byte[] m_iv2 = null;
    byte[] m_aesKeys = null;

    public SymCipher() {
        int n;
        for (n = 0; n < 16; ++n) {
            this.m_iv1[n] = 0;
        }
        this.m_iv2 = new byte[16];
        for (n = 0; n < 16; ++n) {
            this.m_iv2[n] = 0;
        }
    }

    public synchronized int setEncryptionKeyAES(byte[] byArray) {
        return this.setEncryptionKeyAES(byArray, 0, 16);
    }

    public synchronized int setEncryptionKeyAES(byte[] byArray, int n, int n2) {
        try {
            this.m_aesKeys = new byte[16];
            System.arraycopy(byArray, n, this.m_aesKeys, 0, 16);
            this.m_aesEngine1.init(true, (CipherParameters)new KeyParameter(this.m_aesKeys));
            this.m_aesEngine2.init(true, (CipherParameters)new KeyParameter(this.m_aesKeys));
            if (n2 == 16) {
                for (int i = 0; i < 16; ++i) {
                    this.m_iv1[i] = 0;
                    this.m_iv2[i] = 0;
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    this.m_iv1[i] = byArray[i + 16 + n];
                    this.m_iv2[i] = byArray[i + 16 + n];
                }
            }
            return 0;
        }
        catch (Exception exception) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] byArray) {
        try {
            if (byArray.length == 16) {
                return this.setEncryptionKeyAES(byArray);
            }
            this.m_aesKeys = new byte[32];
            System.arraycopy(byArray, 0, this.m_aesKeys, 0, 32);
            this.m_aesEngine1.init(true, (CipherParameters)new KeyParameter(this.m_aesKeys, 0, 16));
            this.m_aesEngine2.init(true, (CipherParameters)new KeyParameter(this.m_aesKeys, 16, 16));
            for (int i = 0; i < 16; ++i) {
                this.m_iv1[i] = 0;
                this.m_iv2[i] = 0;
            }
            return 0;
        }
        catch (Exception exception) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public byte[] getKeys() {
        return this.m_aesKeys;
    }

    public synchronized void setIV2(byte[] byArray) {
        for (int i = 0; i < 16; ++i) {
            this.m_iv2[i] = byArray[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptAES1(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        AESFastEngine aESFastEngine;
        n3 = n + n3;
        while (n < n3 - 15) {
            aESFastEngine = this.m_aesEngine1;
            synchronized (aESFastEngine) {
                this.m_aesEngine1.processBlock(this.m_iv1, 0, this.m_iv1, 0);
            }
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[0]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[1]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[2]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[3]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[4]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[5]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[6]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[7]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[8]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[9]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[10]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[11]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[12]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[13]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[14]);
            byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[15]);
        }
        if (n < n3) {
            aESFastEngine = this.m_aesEngine1;
            synchronized (aESFastEngine) {
                this.m_aesEngine1.processBlock(this.m_iv1, 0, this.m_iv1, 0);
            }
            n3 -= n;
            for (int i = 0; i < n3; ++i) {
                byArray2[n2++] = (byte)(byArray[n++] ^ this.m_iv1[i]);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptAES2(byte[] byArray) {
        AESFastEngine aESFastEngine;
        int n = 0;
        int n2 = byArray.length;
        while (n < n2 - 15) {
            aESFastEngine = this.m_aesEngine2;
            synchronized (aESFastEngine) {
                this.m_aesEngine2.processBlock(this.m_iv2, 0, this.m_iv2, 0);
            }
            int n3 = n++;
            byArray[n3] = (byte)(byArray[n3] ^ this.m_iv2[0]);
            int n4 = n++;
            byArray[n4] = (byte)(byArray[n4] ^ this.m_iv2[1]);
            int n5 = n++;
            byArray[n5] = (byte)(byArray[n5] ^ this.m_iv2[2]);
            int n6 = n++;
            byArray[n6] = (byte)(byArray[n6] ^ this.m_iv2[3]);
            int n7 = n++;
            byArray[n7] = (byte)(byArray[n7] ^ this.m_iv2[4]);
            int n8 = n++;
            byArray[n8] = (byte)(byArray[n8] ^ this.m_iv2[5]);
            int n9 = n++;
            byArray[n9] = (byte)(byArray[n9] ^ this.m_iv2[6]);
            int n10 = n++;
            byArray[n10] = (byte)(byArray[n10] ^ this.m_iv2[7]);
            int n11 = n++;
            byArray[n11] = (byte)(byArray[n11] ^ this.m_iv2[8]);
            int n12 = n++;
            byArray[n12] = (byte)(byArray[n12] ^ this.m_iv2[9]);
            int n13 = n++;
            byArray[n13] = (byte)(byArray[n13] ^ this.m_iv2[10]);
            int n14 = n++;
            byArray[n14] = (byte)(byArray[n14] ^ this.m_iv2[11]);
            int n15 = n++;
            byArray[n15] = (byte)(byArray[n15] ^ this.m_iv2[12]);
            int n16 = n++;
            byArray[n16] = (byte)(byArray[n16] ^ this.m_iv2[13]);
            int n17 = n++;
            byArray[n17] = (byte)(byArray[n17] ^ this.m_iv2[14]);
            int n18 = n++;
            byArray[n18] = (byte)(byArray[n18] ^ this.m_iv2[15]);
        }
        if (n < n2) {
            aESFastEngine = this.m_aesEngine2;
            synchronized (aESFastEngine) {
                this.m_aesEngine2.processBlock(this.m_iv2, 0, this.m_iv2, 0);
            }
            n2 -= n;
            for (int i = 0; i < n2; ++i) {
                int n19 = n++;
                byArray[n19] = (byte)(byArray[n19] ^ this.m_iv2[i]);
            }
        }
        return 0;
    }
}

