/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.IServiceContainer;
import anon.client.Multiplexer;
import anon.client.PacketCounter;
import anon.client.XmlControlChannel;
import anon.crypto.ByteSignature;
import anon.infoservice.MixCascade;
import anon.infoservice.MixPosition;
import anon.pay.IAIEventListener;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.xml.XMLAiLoginConfirmation;
import anon.pay.xml.XMLChallenge;
import anon.pay.xml.XMLEasyCC;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLPayRequest;
import anon.pay.xml.XMLPriceCertificate;
import anon.pay.xml.XMLResponse;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AIControlChannel
extends XmlControlChannel {
    public static final long MAX_PREPAID_INTERVAL = 3000000L;
    public static final long MIN_PREPAID_INTERVAL = 5000L;
    public static final long AI_LOGIN_TIMEOUT = 120000L;
    private static final int FIRST_MIX = 0;
    private static final String SYNCH_AI_LOGIN_MIXVERSION = "00.07.20";
    private static final String PREPAID_AMOUNT_IN_PAY_REQ_MIXVERSION = "00.08.42";
    public static final boolean REVERT_PRE_PREPAID = true;
    private int m_aiLogin_timeout = 30000;
    private static long m_totalBytes = 0L;
    private boolean m_bPrepaidReceived = false;
    private long m_prepaidBytes = 0L;
    private boolean m_bMultiplexerClosed = false;
    private Vector m_aiListeners = new Vector();
    private PacketCounter m_packetCounter;
    private Observer m_packetCountEmptyObserver;
    private boolean m_bEmptyMessageSent = false;
    private MixCascade m_connectedCascade;
    private XMLEasyCC m_initialCC;
    private Vector m_aiLoginSyncObject;
    private volatile boolean m_synchronizedAILogin;
    private boolean m_prepaidAmountInPayRequest = false;

    public AIControlChannel(Multiplexer multiplexer, PacketCounter packetCounter, IServiceContainer iServiceContainer, MixCascade mixCascade) {
        super(2, multiplexer, iServiceContainer, true);
        this.m_packetCounter = packetCounter;
        this.m_connectedCascade = mixCascade;
        this.m_aiLoginSyncObject = new Vector(1);
        String string = this.m_connectedCascade.getMixInfo(0).getServiceSoftware().getVersion();
        if (string != null) {
            this.m_synchronizedAILogin = string.compareTo(SYNCH_AI_LOGIN_MIXVERSION) >= 0;
            this.m_prepaidAmountInPayRequest = string.compareTo(PREPAID_AMOUNT_IN_PAY_REQ_MIXVERSION) >= 0;
        }
        LogHolder.log(6, LogType.PAY, "Mix " + this.m_connectedCascade.getMixInfo(0).getName() + (this.m_synchronizedAILogin ? " supports " : " does not support ") + "synchronized AI logins.");
        LogHolder.log(6, LogType.PAY, "Mix " + this.m_connectedCascade.getMixInfo(0).getName() + (this.m_prepaidAmountInPayRequest ? " supports " : " does not support ") + "improved prepaid bytes negotiation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAIListener(IAIEventListener iAIEventListener) {
        Vector vector = this.m_aiListeners;
        synchronized (vector) {
            if (!this.m_aiListeners.contains(iAIEventListener)) {
                this.m_aiListeners.addElement(iAIEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processXmlMessage(Document document) {
        block18: {
            Element element = document.getDocumentElement();
            String string = element.getTagName();
            try {
                if (string.equals(XMLPayRequest.XML_ELEMENT_NAME)) {
                    XMLPayRequest xMLPayRequest = new XMLPayRequest(element);
                    this.processPayRequest(xMLPayRequest);
                    break block18;
                }
                if (string.equals("LoginConfirmation")) {
                    XMLAiLoginConfirmation xMLAiLoginConfirmation = new XMLAiLoginConfirmation(element);
                    Vector vector = this.m_aiLoginSyncObject;
                    synchronized (vector) {
                        if (xMLAiLoginConfirmation.getCode() == 0) {
                            this.m_aiLoginSyncObject.addElement(new Object());
                        }
                        this.m_aiLoginSyncObject.notifyAll();
                        break block18;
                    }
                }
                if (string.equals("ErrorMessage")) {
                    XMLErrorMessage xMLErrorMessage = new XMLErrorMessage(element);
                    LogHolder.log(2, LogType.PAY, "For account " + PayAccountsFile.getInstance().getActiveAccountNumber() + ", processing AI ErrorMessage " + xMLErrorMessage.getErrorCode() + ": " + xMLErrorMessage.getMessage());
                    if (xMLErrorMessage.getErrorCode() == 10) {
                        this.updateBalance(PayAccountsFile.getInstance().getActiveAccount(), false);
                        PayAccount payAccount = PayAccountsFile.getInstance().getAlternativeChargedAccount(this.m_connectedCascade.getPIID());
                        if (payAccount != null) {
                            PayAccountsFile.getInstance().setActiveAccount(payAccount);
                        } else {
                            this.getServiceContainer().keepCurrentService(false);
                            this.processErrorMessage(new XMLErrorMessage(element));
                        }
                    } else {
                        this.getServiceContainer().keepCurrentService(false);
                        this.processErrorMessage(new XMLErrorMessage(element));
                    }
                } else if (string.equals("Challenge")) {
                    this.processChallenge(new XMLChallenge(element));
                } else if (string.equals(XMLEasyCC.getXMLElementName())) {
                    this.processInitialCC(new XMLEasyCC(element));
                } else {
                    LogHolder.log(4, LogType.PAY, "Received unknown payment control channel message '" + string + "'");
                }
            }
            catch (Exception exception) {
                LogHolder.log(2, LogType.PAY, exception);
                this.getServiceContainer().keepCurrentService(false);
                PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(6, exception.getClass().getName() + ": " + exception.getMessage()));
            }
        }
    }

    private synchronized void handlePrepaidBytesReceived(int n, PayAccount payAccount) {
        if (payAccount == null) {
            throw new NullPointerException("Active Account must not be null!");
        }
        if (n > 0 && !this.m_bPrepaidReceived) {
            this.m_prepaidBytes = n;
            this.m_bPrepaidReceived = true;
            payAccount.updateCurrentBytes(n * -1);
        }
    }

    private synchronized void processChallenge(XMLChallenge xMLChallenge) throws Exception {
        byte[] byArray = xMLChallenge.getChallengeForSigning();
        LogHolder.log(5, LogType.PAY, "Received " + xMLChallenge.getPrepaidBytes() + " prepaid bytes.");
        PayAccount payAccount = PayAccountsFile.getInstance().getActiveAccount();
        if (payAccount == null) {
            throw new Exception("Received Challenge from AI but ActiveAccount not set!");
        }
        if (!this.m_prepaidAmountInPayRequest) {
            this.handlePrepaidBytesReceived(xMLChallenge.getPrepaidBytes(), payAccount);
        }
        byte[] byArray2 = ByteSignature.sign(byArray, payAccount.getPrivateKey());
        XMLResponse xMLResponse = new XMLResponse(byArray2);
        this.sendXmlMessage(XMLUtil.toXMLDocument(xMLResponse));
    }

    private void processErrorMessage(XMLErrorMessage xMLErrorMessage) {
        PayAccountsFile.getInstance().signalAccountError(xMLErrorMessage);
    }

    private synchronized void processPayRequest(XMLPayRequest xMLPayRequest) {
        if (xMLPayRequest.isInitialCCRequest()) {
            if (this.m_prepaidAmountInPayRequest) {
                this.handlePrepaidBytesReceived(xMLPayRequest.getPrepaidBytes(), PayAccountsFile.getInstance().getActiveAccount());
            }
            this.processInitialCC(xMLPayRequest.getCC());
            return;
        }
        if (xMLPayRequest.isAccountRequest() && this.sendAccountCert() != 0) {
            LogHolder.log(1, LogType.PAY, "Could not send account certificate!");
        }
        try {
            this.processCcToSign(xMLPayRequest.getCC());
        }
        catch (Exception exception) {
            LogHolder.log(3, LogType.PAY, exception);
        }
    }

    private void updateBalance(final PayAccount payAccount, final boolean bl) {
        if (payAccount == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    if (bl) {
                        payAccount.fetchAccountInfo(false, 2000);
                    } else {
                        payAccount.fetchAccountInfo(false);
                    }
                }
                catch (Exception exception) {
                    LogHolder.log(7, LogType.PAY, exception);
                }
            }
        };
        if (bl) {
            LogHolder.log(7, LogType.PAY, "Fetching new Balance from BI.");
            runnable.run();
        } else {
            LogHolder.log(7, LogType.PAY, "Fetching new Balance from BI asynchronously.");
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processCcToSign(XMLEasyCC xMLEasyCC) throws Exception {
        long l;
        if (xMLEasyCC == null) {
            return;
        }
        PayAccount payAccount = PayAccountsFile.getInstance().getActiveAccount();
        if (payAccount == null || payAccount.getAccountNumber() != xMLEasyCC.getAccountNumber()) {
            throw new Exception("Received CC with wrong accountnumber");
        }
        payAccount.updateCurrentBytes(this.m_packetCounter);
        XMLEasyCC xMLEasyCC2 = payAccount.getAccountInfo().getCC(xMLEasyCC.getConcatenatedPriceCertHashes());
        long l2 = 0L;
        if (xMLEasyCC2 != null) {
            if (this.m_initialCC == null) {
                LogHolder.log(4, LogType.PAY, "No initial CC available! The Mix might have lost its CC.");
                if (this.m_prepaidBytes > 0L) {
                    payAccount.updateCurrentBytes(this.m_prepaidBytes);
                }
            } else {
                l2 = xMLEasyCC2.getTransferredBytes();
                LogHolder.log(7, LogType.PAY, "Transferred bytes of last CC: " + l2);
            }
        }
        m_totalBytes = l = payAccount.getCurrentBytes();
        long l3 = xMLEasyCC.getTransferredBytes() - l;
        long l4 = l3 - this.m_connectedCascade.getPrepaidInterval();
        if (l4 > 0L) {
            LogHolder.log(4, LogType.PAY, "Illegal number of prepaid bytes for signing. Difference/Spent/CC/PrevCC: " + l4 + "/" + l + "/" + xMLEasyCC.getTransferredBytes() + "/" + l2);
            if (l < 0L) {
                LogHolder.log(4, LogType.PAY, "The mix might have lost a CC. Resetting transferred bytes to zero for now...");
                payAccount.updateCurrentBytes(l * -1L);
                l = payAccount.getCurrentBytes();
            } else if (xMLEasyCC.getTransferredBytes() < l2) {
                LogHolder.log(4, LogType.PAY, "Requested less than confirmed before! Maybe a CC did get lost!");
            }
        }
        xMLEasyCC.setTransferredBytes(l + this.m_connectedCascade.getPrepaidInterval());
        if (xMLEasyCC.getTransferredBytes() > l2) {
            xMLEasyCC.setPriceCerts(this.m_connectedCascade.getPriceCertificateHashes());
            xMLEasyCC.setPIID(payAccount.getAccountCertificate().getPIID());
            xMLEasyCC.setCascadeID(this.m_connectedCascade.getId());
            xMLEasyCC.sign(payAccount.getPrivateKey());
            if (payAccount.addCostConfirmation(xMLEasyCC) <= 0L) {
                LogHolder.log(4, LogType.PAY, "Added old cost confirmation!");
            }
        } else if (xMLEasyCC2 != null && this.m_initialCC != null) {
            xMLEasyCC = xMLEasyCC2;
        } else {
            LogHolder.log(0, LogType.PAY, "Creating zero CC!!");
            xMLEasyCC.setTransferredBytes(0L);
            xMLEasyCC.setPriceCerts(this.m_connectedCascade.getPriceCertificateHashes());
            xMLEasyCC.setPIID(payAccount.getAccountCertificate().getPIID());
            xMLEasyCC.setCascadeID(this.m_connectedCascade.getId());
            xMLEasyCC.sign(payAccount.getPrivateKey());
            payAccount.addCostConfirmation(xMLEasyCC);
        }
        if (this.m_initialCC == null) {
            LogHolder.log(5, LogType.PAY, "Seems to be the first connection to service. Setting initial CC to current CC...");
            this.m_initialCC = xMLEasyCC;
        }
        if (!PayAccountsFile.getInstance().getActiveAccount().isCharged(new Timestamp(System.currentTimeMillis()))) {
            Vector vector = this.m_aiLoginSyncObject;
            synchronized (vector) {
                if (!this.m_bMultiplexerClosed && this.m_packetCountEmptyObserver == null) {
                    this.m_packetCountEmptyObserver = new EmptyAccountPacketObserver(xMLEasyCC.getConcatenatedPriceCertHashes());
                    this.m_packetCounter.addObserver(this.m_packetCountEmptyObserver);
                }
            }
        }
        this.sendXmlMessage(XMLUtil.toXMLDocument(xMLEasyCC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendAccountCert() {
        int n;
        Vector vector;
        String string = null;
        Vector vector2 = this.m_connectedCascade.getPriceCertificates();
        Vector vector3 = this.m_connectedCascade.getMixIds();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        PayAccount payAccount = PayAccountsFile.getInstance().getActiveAccount();
        if (payAccount == null || !payAccount.isCharged(timestamp) || payAccount.getBI() == null || !payAccount.getBI().getId().equals(this.m_connectedCascade.getPIID())) {
            PayAccount payAccount2 = null;
            PayAccount payAccount3 = null;
            if (payAccount != null && payAccount.getCurrentSpent() == 0L) {
                payAccount3 = PayAccountsFile.getInstance().getActiveAccount();
            }
            if ((vector = PayAccountsFile.getInstance().getAccounts(this.m_connectedCascade.getPIID())).size() > 0) {
                int n2;
                for (n2 = 0; n2 < vector.size() && !(payAccount2 = (PayAccount)vector.elementAt(n2)).isCharged(timestamp); ++n2) {
                    if (!(payAccount3 != null || payAccount != null && payAccount.getCurrentSpent() != 0L || payAccount2.hasExpired())) {
                        payAccount3 = payAccount2;
                    }
                    payAccount2 = null;
                }
                if (payAccount2 != null) {
                    PayAccountsFile.getInstance().setActiveAccount(payAccount2);
                } else if (payAccount3 != null) {
                    PayAccountsFile.getInstance().setActiveAccount(payAccount3);
                }
                if (!(PayAccountsFile.getInstance().getActiveAccount() != null && PayAccountsFile.getInstance().getActiveAccount().isCharged(timestamp) || vector.size() <= 0)) {
                    LogHolder.log(4, LogType.PAY, "No charged account is available for connecting. Trying to update balances...");
                    for (n2 = 0; n2 < vector.size(); ++n2) {
                        payAccount2 = (PayAccount)vector.elementAt(n2);
                        if (payAccount2.getBalance() != null && !payAccount2.shouldUpdateAccountInfo()) continue;
                        this.updateBalance(payAccount2, true);
                        if (!payAccount2.isCharged(timestamp)) continue;
                        PayAccountsFile.getInstance().setActiveAccount(payAccount2);
                        break;
                    }
                }
            }
        }
        if ((n = PayAccountsFile.getInstance().signalAccountRequest(this.m_connectedCascade)) != 0) {
            return n;
        }
        payAccount = PayAccountsFile.getInstance().getActiveAccount();
        if (payAccount == null) {
            return -1;
        }
        if (vector2.size() != vector3.size()) {
            string = "Not all Mixes in cascade " + this.m_connectedCascade.getId() + " have price certs! " + "PriceCerts/MixIDs:" + vector2.size() + "/" + vector3.size();
        } else {
            for (int i = 0; i < vector3.size(); ++i) {
                XMLPriceCertificate xMLPriceCertificate = (XMLPriceCertificate)vector2.elementAt(i);
                String string2 = (String)vector3.elementAt(i);
                if (!xMLPriceCertificate.verify(PayAccountsFile.getInstance().getActiveAccount().getBI())) {
                    string = "Price certificate of cascade " + this.m_connectedCascade.getId() + " for mix " + string2 + " cannot be verified!";
                    break;
                }
                if (xMLPriceCertificate.getSubjectKeyIdentifier().equals(string2)) continue;
                string = "SKI in price certificate of cascade " + this.m_connectedCascade.getId() + " differs from Mix ID! SKI:" + xMLPriceCertificate.getSubjectKeyIdentifier() + " MixID: " + string2;
                break;
            }
        }
        if (string != null) {
            LogHolder.log(3, LogType.PAY, string);
            this.getServiceContainer().keepCurrentService(false);
            PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, string));
            return -1;
        }
        payAccount.resetCurrentBytes();
        this.sendXmlMessage(XMLUtil.toXMLDocument(payAccount.getAccountCertificate()));
        int n3 = -1;
        vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            if (this.m_synchronizedAILogin) {
                LogHolder.log(6, LogType.PAY, "Performing new synchronous AI login");
                try {
                    this.m_aiLoginSyncObject.wait(this.m_aiLogin_timeout);
                }
                catch (InterruptedException interruptedException) {
                    n3 = -24;
                }
                if (this.m_aiLoginSyncObject.size() > 0) {
                    n3 = 0;
                }
                this.m_aiLoginSyncObject.removeAllElements();
            } else {
                n3 = 0;
                LogHolder.log(4, LogType.PAY, "Old Mix version does not support synchronous AI login! Performing old asynchronous login procedure");
            }
        }
        return n3;
    }

    public static long getBytes() {
        return m_totalBytes;
    }

    private synchronized void processInitialCC(XMLEasyCC xMLEasyCC) {
        PayAccount payAccount = PayAccountsFile.getInstance().getActiveAccount();
        String string = "AI has sent a INVALID last cost confirmation.";
        if (xMLEasyCC.verify(payAccount.getPublicKey())) {
            try {
                long l;
                if (xMLEasyCC.getNrOfPriceCerts() != this.m_connectedCascade.getNrOfPriceCerts()) {
                    LogHolder.log(2, LogType.PAY, "number of price certificates in cost confirmation does not match number of price certs in cascade");
                    this.getServiceContainer().keepCurrentService(false);
                    PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, "AI sent CC will illegal number of price certs" + xMLEasyCC.getNrOfPriceCerts()));
                    return;
                }
                Hashtable hashtable = xMLEasyCC.getPriceCertHashes();
                Enumeration enumeration = this.m_connectedCascade.getPriceCertificateHashes().keys();
                Hashtable hashtable2 = this.m_connectedCascade.getPriceCertificateHashes();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    MixPosition mixPosition = (MixPosition)enumeration.nextElement();
                    String string2 = (String)hashtable2.get(mixPosition);
                    String string3 = (String)hashtable.get(mixPosition);
                    if (string3 == null || !string2.equals(string3)) {
                        String string4 = "AI sent CC with illegal price cert hash for mix " + (mixPosition.getPosition() + 1) + " (" + (n + 1) + ")" + "!";
                        if (string3 == null) {
                            string4 = string4 + " Price certificate for this Mix was not found in CC!";
                        }
                        LogHolder.log(4, LogType.PAY, string4);
                        this.getServiceContainer().keepCurrentService(false);
                        PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(17, string4));
                        return;
                    }
                    hashtable.remove(mixPosition);
                    ++n;
                }
                LogHolder.log(7, LogType.PAY, "AI has sent a valid last cost confirmation. Adding it to account.");
                if (this.m_initialCC == null) {
                    payAccount.updateCurrentBytes(xMLEasyCC.getTransferredBytes());
                    this.m_initialCC = xMLEasyCC;
                } else {
                    l = xMLEasyCC.getTransferredBytes() - this.m_initialCC.getTransferredBytes();
                    LogHolder.log(4, LogType.PAY, "Updated initial CostConfirmation! Difference: " + l);
                    payAccount.updateCurrentBytes(l);
                }
                l = xMLEasyCC.getTransferredBytes();
                if (payAccount.addCostConfirmation(xMLEasyCC) < 0L) {
                    l = 0L;
                    LogHolder.log(4, LogType.PAY, "Received old cost confirmation!");
                }
                long l2 = payAccount.getCurrentBytes();
                long l3 = this.m_connectedCascade.getPrepaidInterval() - (l - l2);
                long l4 = xMLEasyCC.getTransferredBytes();
                XMLEasyCC xMLEasyCC2 = new XMLEasyCC(xMLEasyCC);
                if (l3 > 0L) {
                    xMLEasyCC2.setTransferredBytes(l + l3);
                } else {
                    xMLEasyCC2.setTransferredBytes(l);
                }
                xMLEasyCC2.sign(payAccount.getPrivateKey());
                if (l3 > 0L && payAccount.addCostConfirmation(xMLEasyCC2) <= 0L) {
                    LogHolder.log(4, LogType.PAY, "Sending old cost confirmation! Diff (ShoulBe)/Old/New:" + l3 + "/" + l4 + "/" + xMLEasyCC2.getTransferredBytes());
                }
                this.sendXmlMessage(XMLUtil.toXMLDocument(xMLEasyCC2));
                return;
            }
            catch (Exception exception) {
                LogHolder.log(2, LogType.PAY, string, exception);
            }
        } else {
            LogHolder.log(3, LogType.PAY, string);
        }
        this.getServiceContainer().keepCurrentService(false);
        PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(3, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multiplexerClosed() {
        Vector vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            this.m_bMultiplexerClosed = true;
            if (this.m_packetCountEmptyObserver != null) {
                this.m_packetCounter.deleteObserver(this.m_packetCountEmptyObserver);
            }
            this.m_aiLoginSyncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAILoginTimeout(int n) {
        Vector vector = this.m_aiLoginSyncObject;
        synchronized (vector) {
            this.m_aiLogin_timeout = n;
        }
    }

    public boolean isPrepaidAmountInPayRequest() {
        return this.m_prepaidAmountInPayRequest;
    }

    public void setPrepaidAmountInPayRequest(boolean bl) {
        this.m_prepaidAmountInPayRequest = bl;
    }

    private final class EmptyAccountPacketObserver
    implements Observer {
        private String m_concatenatedPCHashes;

        private EmptyAccountPacketObserver(String string) {
            this.m_concatenatedPCHashes = string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Observable observable, Object object) {
            Vector vector = AIControlChannel.this.m_aiLoginSyncObject;
            synchronized (vector) {
                if (!AIControlChannel.this.m_bEmptyMessageSent) {
                    PayAccount payAccount = PayAccountsFile.getInstance().getActiveAccount();
                    try {
                        payAccount.updateCurrentBytes(AIControlChannel.this.m_packetCounter);
                        XMLEasyCC xMLEasyCC = payAccount.getAccountInfo().getCC(this.m_concatenatedPCHashes);
                        long l = xMLEasyCC.getTransferredBytes() - payAccount.getCurrentBytes() + AIControlChannel.this.m_prepaidBytes;
                        long l2 = payAccount.getCurrentCreditCalculatedAlsoNegative();
                        if (l2 < 0L) {
                            l += l2;
                        }
                        if (l > 0L) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        LogHolder.log(2, LogType.PAY, exception);
                    }
                    PayAccountsFile.getInstance().signalAccountError(new XMLErrorMessage(10));
                    for (int i = 0; i < AIControlChannel.this.m_aiListeners.size(); ++i) {
                        ((IAIEventListener)AIControlChannel.this.m_aiListeners.elementAt(i)).accountEmpty(PayAccountsFile.getInstance().getActiveAccount(), AIControlChannel.this.m_connectedCascade);
                    }
                    AIControlChannel.this.m_bEmptyMessageSent = true;
                }
            }
        }
    }
}

