/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.Invoker;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;

public class XmlRpcServer {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Hashtable handlers = new Hashtable();
    private Stack pool = new Stack();
    private int workers = 0;

    public void addHandler(String string, Object object) {
        if (object instanceof XmlRpcHandler || object instanceof AuthenticatedXmlRpcHandler) {
            this.handlers.put(string, object);
        } else if (object != null) {
            this.handlers.put(string, new Invoker(object));
        }
    }

    public void removeHandler(String string) {
        this.handlers.remove(string);
    }

    public byte[] execute(InputStream inputStream) {
        return this.execute(inputStream, null, null);
    }

    public byte[] execute(InputStream inputStream, String string, String string2) {
        Worker worker = this.getWorker();
        byte[] byArray = worker.execute(inputStream, string, string2);
        this.pool.push(worker);
        return byArray;
    }

    private final Worker getWorker() {
        try {
            return (Worker)this.pool.pop();
        }
        catch (EmptyStackException emptyStackException) {
            int n = XmlRpc.getMaxThreads();
            if (this.workers < n) {
                ++this.workers;
                if ((double)this.workers >= (double)n * 0.95) {
                    System.err.println("95% of XML-RPC server threads in use");
                }
                return new Worker();
            }
            throw new RuntimeException("System overload");
        }
    }

    class Worker
    extends XmlRpc {
        private Vector inParams = new Vector();
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private XmlRpc.XmlWriter writer;

        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] execute(InputStream inputStream, String string, String string2) {
            try {
                byte[] byArray = this.executeInternal(inputStream, string, string2);
                return byArray;
            }
            finally {
                this.buffer.reset();
                this.inParams.removeAllElements();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] executeInternal(InputStream inputStream, String string, String string2) {
            byte[] byArray;
            long l = 0L;
            if (XmlRpc.debug) {
                l = System.currentTimeMillis();
            }
            try {
                this.parse(inputStream);
                if (XmlRpc.debug) {
                    System.err.println("method name: " + this.methodName);
                    System.err.println("inparams: " + this.inParams);
                }
                if (this.errorLevel > 0) {
                    throw new Exception(this.errorMsg);
                }
                Object var7_5 = null;
                String string3 = null;
                int n = this.methodName.lastIndexOf(46);
                if (n > -1) {
                    string3 = this.methodName.substring(0, n);
                    var7_5 = XmlRpcServer.this.handlers.get(string3);
                    if (var7_5 != null) {
                        this.methodName = this.methodName.substring(n + 1);
                    }
                }
                if (var7_5 == null) {
                    var7_5 = XmlRpcServer.this.handlers.get("$default");
                }
                if (var7_5 == null) {
                    if (n > -1) {
                        throw new Exception("RPC handler object \"" + string3 + "\" not found and no default handler registered.");
                    }
                    throw new Exception("RPC handler object not found for \"" + this.methodName + "\": no default handler registered.");
                }
                Object object = var7_5 instanceof AuthenticatedXmlRpcHandler ? ((AuthenticatedXmlRpcHandler)var7_5).execute(this.methodName, this.inParams, string, string2) : ((XmlRpcHandler)var7_5).execute(this.methodName, this.inParams);
                if (XmlRpc.debug) {
                    System.err.println("outparam = " + object);
                }
                this.writer = new XmlRpc.XmlWriter(this.buffer);
                this.writeResponse(object, this.writer);
                this.writer.flush();
                byArray = this.buffer.toByteArray();
            }
            catch (Exception exception) {
                if (XmlRpc.debug) {
                    exception.printStackTrace();
                }
                this.buffer.reset();
                this.writer = null;
                try {
                    this.writer = new XmlRpc.XmlWriter(this.buffer);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.err.println("XmlRpcServer attempted to use unsupported encoding: " + unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    System.err.println("XmlRpcServer experienced I/O error writing error response: " + iOException);
                }
                String string4 = exception.toString();
                int n = exception instanceof XmlRpcException ? ((XmlRpcException)exception).code : 0;
                try {
                    this.writeError(n, string4, this.writer);
                    this.writer.flush();
                }
                catch (Exception exception2) {
                    System.err.println("Unable to send error response to client: " + exception2);
                }
                byArray = this.writer != null ? this.buffer.toByteArray() : EMPTY_BYTE_ARRAY;
            }
            finally {
                if (this.writer != null) {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        System.err.println("Exception closing output stream: " + iOException);
                    }
                }
            }
            if (XmlRpc.debug) {
                System.err.println("Spent " + (System.currentTimeMillis() - l) + " millis in request");
            }
            return byArray;
        }

        void objectParsed(Object object) {
            this.inParams.addElement(object);
        }

        void writeResponse(Object object, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException, IOException {
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("params");
            xmlWriter.startElement("param");
            xmlWriter.writeObject(object);
            xmlWriter.endElement("param");
            xmlWriter.endElement("params");
            xmlWriter.endElement("methodResponse");
        }

        void writeError(int n, String string, XmlRpc.XmlWriter xmlWriter) throws XmlRpcException, IOException {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("faultCode", new Integer(n));
            hashtable.put("faultString", string);
            xmlWriter.startElement("methodResponse");
            xmlWriter.startElement("fault");
            xmlWriter.writeObject(hashtable);
            xmlWriter.endElement("fault");
            xmlWriter.endElement("methodResponse");
        }
    }
}

